/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxVtkBaseView_SceneManager_h_INCLUDED_H__
#define __wxVtkBaseView_SceneManager_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include "ContourWrap_ViewControl.h"
#include "wxVtkBaseView.h"
#include <iostream>
#include <map>
#include "manualContourModel.h"
#include "manualRoiControler.h"
#include "manualContourBaseControler.h"
#include "manualCircleControler.h"
#include "manualLineControler.h"
#include "manualViewBaseContour.h"
#include "manualViewBullEye.h"
#include "manualViewCircle.h"
#include "manualViewLine.h"
#include "manualViewPoints.h"
#include "manualViewRoi.h"
#include <wx/event.h>

//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------
BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( wxEVT_START_CREATE_MULT_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_STOP_CREATE_MULT_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_SELECTED_MULT_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_START_CREATE_ROI, -1 )
	DECLARE_EVENT_TYPE( wxEVT_STOP_CREATE_ROI, -1)
	DECLARE_EVENT_TYPE( wxEVT_DELETE_ROI, -1 )
	DECLARE_EVENT_TYPE( wxEVT_SELECTED_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_UNSLECTED_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_MANUAL_HIDED_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_MANUAL_SHOWED_ROI, -1 )
	DECLARE_EVENT_TYPE( wxEVT_EDITING_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_MOVING_ROI, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_MOVING_ROI_POINT, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_SELECTED_ROI_POINT, -1 )	
	DECLARE_EVENT_TYPE( wxEVT_UNSELECTED_ROI_POINT, -1 )			
	DECLARE_EVENT_TYPE( wxEVT_CHANGED_DEEP, -1 )
END_DECLARE_EVENT_TYPES()

/** file wxVtkBaseView_SceneManager.h */


//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------
class wxVtkBaseView_SceneManager : public InteractorStyleMaracas {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	wxVtkBaseView_SceneManager( wxVtkBaseView * theWxBaseViewToManage, wxEvtHandler * theEventHandler, double * spc );
	~wxVtkBaseView_SceneManager();

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	
		
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------
	void sendEnvent( WXTYPE theEventType, std::string text );

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	void setWxVtkViewBase( wxVtkBaseView * theBaseView );
	void setWxEventHandler( wxEvtHandler * theEventHandler );
	wxVtkBaseView * getWxVtkViewBase();

	//
	// Method which creates and associates view and controller to the contour model type pointed in parameter.
	// The possible contour types are:
	// 0-spline
	// 1-spline
	// 2-rectangle
	// 3-circle
	// 4-BullEye
	// 5-BullEyeSector
	// 6-Line
	// 7-Points
	// NOTE: The model is created in the KernelManagerContour class, factoryManualContourModel method
	// @param typeContour - int
	// @param theKeyName - string
	// @param manContourControl - manualBaseModel
	// @param spc - double*  3-pos Array 
	void configureViewControlTo( std::string theKeyName, manualBaseModel * manContourControl, double * spc ,int typeContour);

	void configureSelectionROI( double * spc );
	ContourWrap_ViewControl * insertWrap( std::string theKeyName, manualContourBaseControler * manContourControl, manualViewBaseContour  * manViewerContour ); 
	void desconfigureViewControlOf( std::string theKeyName );
	void removeWrap( std::string theKeyName );
	ContourWrap_ViewControl * getContourWrap_ViewControlOf ( std::string theName );
	ContourWrap_ViewControl * getContourWrap_ViewControlOf ( std::string theName, std::map<std::string, ContourWrap_ViewControl *> * theMap );
	manualContourBaseControler * getControlerOf( std::string theName );
	manualViewBaseContour * getViewerOf( std::string theName );
	void set_creatingMULT_ROI( bool condition );
	void set_editingROI( bool condition );
	void set_toIncludeAtInteractionGroup( bool condition );
	void set_waiting( bool condition );
	bool get_creatingMULT_ROI(  );
	bool get_editingROI(  );
	bool get_toIncludeAtInteractionGroup(  );
	bool get_waiting(  );
	bool get_creatingROI();
	void set_creatingROI( bool theCondition );

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void createCopyContourOf( std::string anExistingKName, std::string cloneName, manualBaseModel * manualModel, bool append = false );
	void removeFromScene( ContourWrap_ViewControl * contourWRP, bool visualization = true, bool control = true );
	void removeFromScene( std::string theKeyName, bool visualization = true, bool control = true );
	void removeSceneContours( );
	void removeAllOutlines();
	void addToScene( std::string theKeyName, bool append = true, bool visualization = true, bool control = true, bool ifActive = true, bool ifShowCtrlPoints = true );
	void addToScene( std::string theKeyName, ContourWrap_ViewControl * contourWRP, bool append = true, bool visualization = true, bool control = true, bool ifActive = true, bool ifShowCtrlPoints = true );
	void removeFromScene( std::vector< std::string> theKeyNameVector, bool visualization = true, bool control = true );
	void addToScene( std::vector< std::string> theKeyNameVector, bool append = true, bool visualization = true, bool control = true, bool ifActive = true, bool ifShowCtrlPoints = true );
	void setControlActiveStateOfALL( bool stateCondition );
	void setControlActiveStateOf( std::string theKeyName, bool stateCondition );
	void setControlActiveStateOf( ContourWrap_ViewControl * contourWRP, bool stateCondition );
	void setVisibleStateOf( std::string theKeyName, bool stateCondition );

	std::vector< std::string >  getSelectedObjects();
	void selectObjects( std::vector< std::string > theExistingObjectsToSelect );
	void selectObjects( std::map<std::string, ContourWrap_ViewControl *> * theMap );
	void setControlActiveStateOf( std::vector< std::string> &theKeyNameVector, bool controlCondition = false );
	void setControlActiveStateOf( std::map<std::string, ContourWrap_ViewControl *> * theMap, bool controlCondition = false );
	void drawSelectionROI();
	void setSelection2DROIInternalOutlines( );
	void writeCoords( std::string method );

   // EED
	void SaveThingName(FILE *ff, std::string nameThing);
	void GetPointsOfActualContour( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ );	
	vtkImageData *GetImageData();
	std::vector<std::string> GetlstContoursNameActualSlice();

	//------------------------------------------------------------------------------------------------------------
	// Inherited Methods
	//------------------------------------------------------------------------------------------------------------

	virtual bool  OnChar();
	virtual bool  OnMouseMove();
	virtual bool  OnLeftButtonDown(); 
	virtual bool  OnLeftButtonUp();
	virtual bool  OnMiddleButtonDown(); 
	virtual bool  OnMiddleButtonUp();
	virtual bool  OnRightButtonDown();
	virtual bool  OnRightButtonUp();

	virtual bool  OnLeftDClick();
	virtual	bool  OnRightDClick();   
	virtual	bool  OnMiddleDClick();  
	virtual	bool  OnMouseWheel(); 

	int			  GetImageDataSizeZ();
	void		  GetImageDataRange( double *range );
	void			SetWidthContour(double width);

//JCP 21 - 09 - 08
	bool isEditableCControler(std::string theKeyName);
	void deleteCViewerCControler(std::string theKeyName);
	bool isCtrlPressed();
	bool isShiftPressed();
	char getLastKeyCode();
private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	
	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	
	std::map<std::string, ContourWrap_ViewControl *> * _contours_ViewControl;
	std::map<std::string, ContourWrap_ViewControl *> * _sceneContours_ViewControl;
	wxVtkBaseView				*_wxVtk_BaseView;
	wxEvtHandler				*_eventHandler;
	ContourWrap_ViewControl 		*_lastInteraction;
	std::string				_lastInteractionName;
	std::map<std::string, ContourWrap_ViewControl *> * _workingGroup;
	bool					_creatingMULT_ROI;
	bool					_editingROI;
	bool					_toIncludeAtInteractionGroup;
	bool					_waiting;
	bool					_creatingROI;
	int					_enventID;
	int					_leftClickCount;
	int					_rigthClickCount;
	int					clickX;
	int					clickY;
	char					_lastKeyCode;
	long int				onCharCallBackTimeEnd;
	long int				onCharNeeded;
	bool					_drawingSelectionROI;
	manualRoiControler			*_controlerSelectionROI;
	manualViewRoi				*_viewerSelectionROI;
	manualBaseModel				*_modelSelectionROI;
	double					_widthOfContour;
	double					_widthOfControlPoint;

	bool _ctrlKey;
	bool _shiftKey;
};
#endif // __wxVtkBaseView_SceneManager_HEADER_FILE__

