/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



// SYSTEM INCLUDES
#include <iostream>
#include <map>
#include <vector>
#include <string>

// PROJECT INCLUDES

#include "EnvironmentEnvironmentHandler"

// LOCAL INCLUDES

// FORWARD REFERENCES

/*
*	COMMENT
*	@param
*	@return
*/
#ifndef __EnvironmentHandler_h__INCLUDED
template <class P>

class EnvironmentHandler
	{
				public:
						//====== LIFECYCLE ========
						EnvironmentHandler(SomeEnvironment<P>* environment);
						~EnvironmentHandler();
													
						//====== OPERATIONS =======
						/*
						* change the actual intants associated to the
						* names given
						*/
						void nextInstants(std::vector<std::string> nameConcepts);
						
						/*
						* adds an actual	Instant to a concept, it means, this instant
						* has all index fixed, except the index in the instant of the concept
						* identified by nameConcept
						*/
						void addActualInstantOfCOncept(std::string nameConcept,Instant* instant);
						
						/*
						* removes the  pair in the map of actual concepts
						*/
						void removeActualInstantOfConcept(std::string nameConcept);
						
						//====== INQUIRY =========
						/*
						* get all the actual instants
						*/
						void getActualsInstants(std::vector<Instant*>& instantsVector);
						
						/*
						* get the actual instant fot the concept identified by the name
						*/
						Instant* getActualInstant(std::string nameConcept);
						//====== ACCESS ==========
					
						

						
				private:
					
					//======= ATTRIBUTES=======
					
					/*
					*	actual instants of the environmenHandler
					*/
					
					std::map<std::string,Instant*>		actualInstants;
					/*
					*	Environment that's being handled
					*/
				
					SomeEnvironment<P>* environment;
					//====== PRIVATE METHODS=========
				
							
	};
//include the implementation of the template
#include "EnvironmentHandler_Txx.h"
#endif
