/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*=========================================================================

  Program:  instantHandler
  Module:    $RCSfile: InstantHandler_Txx.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 12:12:26 $
  Version:   $Revision: 1.2 $
  Objective: Handles the change of instant among the concept already inscribed
  Authot:	Monica Maria Lozano Romero

  Copyright: (c) 2007
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.


=========================================================================*/

// SYSTEM INCLUDES


// PROJECT INCLUDES


// LOCAL INCLUDES
//#include "Instant.h"


// FORWARD REFERENCES

//NAMESPACE

						//====== LIFECYCLE ========
						
						template<class P>	
						InstantHandler<P>::InstantHandler(SomeEnvironment<P>* environment)throw (ViewerNDimensionsException)
							{
								
								this->hasNext=true;
								this->hasPrevious=true;
								this->actualConcept=NULL;
								this->actualTime=0.0;
								this->pauseTime=0.0;
								if(environment)
									{
										this->environment=environment;
										this->actualInstant=new Instant(environment->getNumberOfConcepts());
									}
								else
									{
										this->environment=NULL;
										this->actualInstant=NULL;
										throw new ViewerNDimensionsException("ERROR ENVIRONMENT NULL");
									}
								
							}
						
						template<class P>	
						InstantHandler<P>::~InstantHandler()
							{
								int i,size;
								//deleting conceptsToChange
								size=getSizeConceptsToChange();
								for(i=0;i<size;i++)
									{
										if(conceptsToChange[i])
											delete conceptsToChange[i];
									}
								this->conceptsToChange.clear();
								//deleting actual concept
								if(actualInstant) delete actualInstant;
								


							}
													
						//====== OPERATIONS =======
						/*
						*	Adds a concept to handled in the instant, it means, when 
						*	the next instant is used we are going to change this concepts in the instant
						*	PRECONDITION
						*	the calls to this functions are made in order of position, where the last position (it means
						*	the higher position defined) is the concept thats is going to handled the real time
						*	THE LAST POSITION HANDLEDS THE REAL TIME DOESNT MATTER THE CONCEPT
						*	EXAMPLE
						*	The user wants to reproduce doctors, pacients and time, and positions given are:
						*	0=reproduce doctors, 1= reproduce pacients, 2= time, then  1,2 are going to be reproduced
						*	by PLUS PLUS, and time by REAL TIME
						*	@param nameConcept, name of the concept
						*	@param mode, mode of change
						*	@param position, position of reproduction
						*	@return true if succesful, false otherwise
						*/
						template<class P>
						bool InstantHandler<P>::addConceptToHandled(std::string nameConcept,int mode,int position) throw (ViewerNDimensionsException)
							{
								if(environment)
									{
										//creating the concept
										ConceptInstantHandler* conceptInstantHandler=new ConceptInstantHandler(nameConcept,mode,position);
										//looking  for its index
										int indexInInstant=environment->getIndexConcept(nameConcept);
										if(indexInInstant!=-1)
											conceptInstantHandler->setIndexInInstant(indexInInstant);
										else
											throw new ViewerNDimensionsException("ERROR CONCEPT ISN'T IN ENVIRONMENT");
										//setting it maximums
										int maximumIndex=environment->getSizeConcept(nameConcept);
										if(maximumIndex!=-1)
											conceptInstantHandler->setMaximumIndex(maximumIndex);
										else
											throw new ViewerNDimensionsException("ERROR CONCEPT ISN'T IN ENVIRONMENT");
										//adding the concept
										this->conceptsToChange.push_back(conceptInstantHandler);
										actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
										actualInstant->setConcept(indexInInstant,conceptInstantHandler->geActualIndex());
										return true;
									}
								else
									{
										return false;
									}
							}

						
						/*
						*	Next instant of the concepts to change
						*	PRECONDITION
						*	conceptsToChange is ordered by the position of the concepts handled
						*	@param 
						*	@return
						*/
						template<class P>
						void InstantHandler<P>::nextInstant() throw (ViewerNDimensionsException)
							{
								if(actualConcept)
								{
									bool hasNextIndex=actualConcept->hasNextIndex();
									int position=actualConcept->getPosition();
									if(hasNextIndex)
										{
											actualConcept->nextIndex();
											actualInstant->setConcept(actualConcept->getIndexInInstant(),actualConcept->geActualIndex());
											
										}
									else
										{
											while( (position-1)>=0 && !hasNextIndex)
												{
													actualConcept=conceptsToChange[position-1];	
													hasNextIndex=actualConcept->hasNextIndex();
													position=actualConcept->getPosition();
												}
											if(hasNextIndex)
												{
													actualConcept->nextIndex();
													actualInstant->setConcept(actualConcept->getIndexInInstant(),actualConcept->geActualIndex());
													resetNextConcepts();
													actualConcept=conceptsToChange[getSizeConceptsToChange()-1];												
												}
											else
												actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
											
										}
									setHasNext();	
									setHasPrevious();
								}
								else
									throw new ViewerNDimensionsException("ERROR THERE ISN'T CONCEPTS TO HANDLED IN THE PLAYER");
							}
						
					
						/*
						*	Previous instant of the actual concept
						*	@param 
						*	@return
						*/
						template<class P>
						void InstantHandler<P>::previousInstant()throw (ViewerNDimensionsException)
							{
								if(actualConcept)
								{
									bool hasPreviousIndex=actualConcept->hasPreviousIndex();
									int position=actualConcept->getPosition();
									if(hasPreviousIndex)
										{
											actualConcept->previousIndex();
											actualInstant->setConcept(actualConcept->getIndexInInstant(),actualConcept->geActualIndex());
											
										}
									else
										{
											while( (position-1)>=0 && !hasPreviousIndex)
												{
													actualConcept=conceptsToChange[position-1];	
													hasPreviousIndex=actualConcept->hasPreviousIndex();
													position=actualConcept->getPosition();
												}
											if(hasPreviousIndex)
												{
													actualConcept->previousIndex();
													actualInstant->setConcept(actualConcept->getIndexInInstant(),actualConcept->geActualIndex());
													setNextConcepts();
													actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
												}
											else
												actualConcept=conceptsToChange[getSizeConceptsToChange()-1];

										}
									setHasPrevious();
									setHasNext();
								}
								else
									throw new ViewerNDimensionsException("ERROR THERE ISN'T CONCEPTS TO HANDLED IN THE PLAYER");
							}		

						/*
						* Removes all the concept handled
						*/
						template<class P>
						void InstantHandler<P>::removeAllConcepts()
							{
								int size,i;
								size=getSizeConceptsToChange();
								for(i=0;i<size;i++)
									{
										if(conceptsToChange[i])
											delete conceptsToChange[i];
									}
								conceptsToChange.clear();
								actualConcept=NULL;

							}
						
						/*
						*	Removes the concept with the name given
						*	@param nameConcept, name of the concept to remove
						*	WARNING the user know wich concept is erasing, also knows the
						*	mode of other concepts, if the user is deleting the concept that
						*	handled the real time, should change the mode to other concept that exist
						*/
						template<class P>
						void InstantHandler<P>::removeConceptToHandled(std::string nameConcept)
							{
								int size,i;
								size=getSizeConceptsToChange();
								std::vector<ConceptInstantHandler*>::iterator iteratorConcepts=conceptsToChange.begin();
								ConceptInstantHandler* concepti;
								std::string nameConcepti;
								bool isConcept=false;
								for(i=0;i<size && !isConcept;i++)
									{
										concepti=conceptsToChange[i];
										nameConcepti=concepti->getName();
										if(nameConcepti.compare(nameConcept)==0)
											{
												if(actualConcept==concepti)
													actualConcept=NULL;
												conceptsToChange.erase(iteratorConcepts);
												actualConcept=conceptsToChange[size-1];
												isConcept=true;
											}
									iteratorConcepts++;
									}
							}
						
						/*
						* sets all the concept to handled in 0
						*/
						template<class P>
						void InstantHandler<P>::resetConceptsHandled()
							{
								int size,i;
								size=getSizeConceptsToChange();
								ConceptInstantHandler* concepti;
								int indexInInstant=-1;
								for(i=0;i<size;i++)
									{
										concepti=conceptsToChange[i];
										concepti->setActualIndex(0);
										indexInInstant=concepti->getIndexInInstant();
										actualInstant->setConcept(indexInInstant,0);
									}
								setHasNext();
								setHasPrevious();
							}
						/*
						* Pause
						*/
						/*
						template<class P>
						void InstantHandler<P>::pause()
							{
								time_t seconds=time(NULL);
								pauseTime=seconds*1000;
							}
						*/
						//====== INQUIRY =========
						
						/*
						* get the actual instant fot the concept identified by the name
						*/
						template<class P>
						Instant* InstantHandler<P>::getActualInstant()throw (ViewerNDimensionsException)
							{
								if(this->actualInstant)
									return this->actualInstant;
								else
									throw new ViewerNDimensionsException("ERROR ACTUAL INSTANT IS NOT SETTED");
							}
						
						
						/*
						* If the actual concept has next instant, it means, if the index of the concept
						* in the  instant is in the maximum value
						* @param nameConcept, concept for which we need to know if we are 
						* in its maximum value
						* @return true if IS NOT in the maximum, false otherwise 
						*/
						template<class P>
						bool InstantHandler<P>::hasNextInstant()
							{
								return hasNext;
							}
						
						
						
						/*
						* If the concept has previous instant, it means, if the index of the concept
						* in the  instant is positive
						* @param nameConcept, concept for which we need to know if we are 
						* in Zero
						* @return true if IS NOT in zero, false otherwise 
						*/
						template<class P>
						bool InstantHandler<P>::hasPreviousInstant()
							{
								return hasPrevious;
							}
						/*
						* returns the number con conceptsToHandled
						*/
						template<class P>
						int InstantHandler<P>::getSizeConceptsToChange()
							{
								return conceptsToChange.size();
							}
						/*
						* returns the number of possibles instants of the handler
						* it depends of the concepts added in conceptsTochange
						*/
						template<class P>
						int InstantHandler<P>::getNumOfInstants()
							{
								int i,size,numInstants=1;
								size=getSizeConceptsToChange();
								ConceptInstantHandler* concepti;
								for(i=0;i<size;i++)
									{
										concepti=conceptsToChange[i];
										numInstants*=concepti->getMaximumIndex();
									}
								return numInstants;

							}
							
						/*
						*	Returns the names of the concepts handled and its modes
						*	DEPRECATED
						*/
						template<class P>
						void InstantHandler<P>::getConceptsInfo(std::vector<std::string>& namesConcepts,std::vector<int>& modes)
							{
								int size,i;
								size=getSizeConceptsToChange();
								ConceptInstantHandler* concepti;
								for(i=0;i<size;i++)
									{
										concepti=conceptsToChange[i];
										namesConcepts.push_back(concepti->getName());
										modes.push_back(concepti->getMode());
									}
							}
						/*
						*	Returns the name of the concept that handled the real time
						*	DEPRECATED
						*/
						template<class P>
						void InstantHandler<P>::getTimeConcept(std::string& nameConcept)
							{
								ConceptInstantHandler* concept=conceptsToChange[getSizeConceptsToChange()-1];
								nameConcept=concept->getName();
							}

						//====== ACCESS ==========
						/*
						*	Sets the environment that is going to be handled
						*	@param environment, a pointer to the environmen
						*	@return
						*/
						template<class P>
						void InstantHandler<P>::setEnvironment(SomeEnvironment<P>* environment)
							{
								this->environment=environment;
							}
						/*
						*	Sets the actual instant of the instant handler
						*/
						template<class P>
						void InstantHandler<P>::setActualInstant(Instant* instant)
							{	
								if(!actualInstant)
									actualInstant=new Instant(instant->getInstant());
								else
									{
										int i,size;
										size=actualInstant->getSize();
										for(i=0;i<size;i++)											
												actualInstant->setConcept(i,instant->getIndexInConcept(i));
									}
								setConceptsToChange();
							}
						
						/*
						*	Sets the  time of reproduction to the concept
						*	that depends of the real time of the reproduction
						*	(seconds)
						*	@param  timeReproduction
						*/
						template<class P>
						void InstantHandler<P>::setTimeReproduction(double time)
							{
								if(getSizeConceptsToChange()>0)
								{
									ConceptInstantHandler* concept=conceptsToChange[getSizeConceptsToChange()-1];
									concept->setTimeReproduction(time);
								}
							}
						/*
						*	Sets the actual time of the reproduction,
						*	is the real time (seconds)
						*	@param instant
						*/
						template<class P>
						void InstantHandler<P>::setActualTime(double actualTime)
							{
								ConceptInstantHandler* concept=conceptsToChange[getSizeConceptsToChange()-1];
								concept->setActualTime(actualTime);
								this->actualTime=actualTime;
							}
						/*
						* Set the mode of a concept that's being handled
						*/
						template<class P>
						void InstantHandler<P>::setModeOfConcept(std::string nameConcept,int mode)
							{
								int size,i;
								size=getSizeConceptsToChange();
								ConceptInstantHandler* concepti;
								std::string nameConcepti;
								bool isConcept=false;
								for(i=0;i<size && !isConcept;i++)
									{
										concepti=conceptsToChange[i];
										nameConcepti=concepti->getName();
										if(nameConcepti.compare(nameConcept)==0)
											{
												isConcept=true;
												concepti->setMode(mode);
											}

									}
							}
						/*
						* Set handler
						*/
						template<class P>
						void InstantHandler<P>::set()
							{
								if(getSizeConceptsToChange()!=0)
									actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
							}
						 /*
						* Set the increase Value for changing the instant
						*/
						template<class P>
						void InstantHandler<P>::setIncreaseValue(int increase)
							{
								int size,i;
								size=conceptsToChange.size();
								ConceptInstantHandler* concepti;
								for(i=0;i<size;i++)
									{
										concepti=conceptsToChange[i];
										concepti->setIncreaseValue(increase);
									}

							}
						/*
						* Set the decrease Value for changing the instant
						*/
						template<class P>
						void InstantHandler<P>::setDecreaseValue(int decrease)
							{
								int size,i;
								size=conceptsToChange.size();
								ConceptInstantHandler* concepti;
								for(i=0;i<size;i++)
									{
										concepti=conceptsToChange[i];
										concepti->setDecreaseValue(decrease);
									}
							}

						//====== PRIVATE METHODS=========
						
						/*
						*  Sets if the instant has next or not
						*/
						
						template<class P>
						void InstantHandler<P>::setHasNext()
							{
								int i, sizeConceptsToChange;
								ConceptInstantHandler* concepti;
								hasNext=false;
								sizeConceptsToChange=getSizeConceptsToChange();
								for(i=0;i<sizeConceptsToChange && !hasNext;i++)
									{
										concepti=conceptsToChange[i];
										if(concepti->hasNextIndex())
												hasNext=true;
									}


							}
						/*
						*  Sets if the instant has previous or not
						*/
						template<class P>
						void InstantHandler<P>::setHasPrevious()
							{
								int i, sizeConceptsToChange;
								ConceptInstantHandler* concepti;
								hasPrevious=false;
								sizeConceptsToChange=getSizeConceptsToChange();
								for(i=0;i<sizeConceptsToChange && !hasPrevious;i++)
									{
										concepti=conceptsToChange[i];
										if(concepti->hasPreviousIndex())
												hasPrevious=true;
									}
							}
						/*
						* actualize the actual index of the concepts handled
						*/
						template<class P>
						void InstantHandler<P>::setConceptsToChange()
							{
									int i,sizeConceptsToChange, indexInInstant,indexInConcept;
									sizeConceptsToChange=getSizeConceptsToChange();
									ConceptInstantHandler* concepti;
									for(i=0;i<sizeConceptsToChange;i++)
										{
											concepti=conceptsToChange[i];
											indexInInstant=concepti->getIndexInInstant();
											indexInConcept=actualInstant->getIndexInConcept(indexInInstant);
											concepti->setActualIndex(indexInConcept);											
										}
							}
					/*
					*	resets all the next concepts to zero
					*/
					template<class P>
					void InstantHandler<P>::resetNextConcepts()
						{
							int i,index,size;
							index=actualConcept->getPosition();
							size=getSizeConceptsToChange();
							ConceptInstantHandler* concepti;
							for(i=index+1;i<size;i++)
								{
									concepti=conceptsToChange[i];
									concepti->setActualIndex(0);
									concepti->resetInitialTime();
									actualInstant->setConcept(concepti->getIndexInInstant(),0);
								}
								
						}
					/*
					* Sets the next index of concepts to handled to the maximum value
					*/
					template<class P>
					void InstantHandler<P>::setNextConcepts()
						{
							int i, index,size;
							index=actualConcept->getPosition();
							size=getSizeConceptsToChange();
							ConceptInstantHandler* concepti;
							for(i=index+1;i<size;i++)
								{
									concepti=conceptsToChange[i];
									concepti->setActualIndex(concepti->getMaximumIndex()-1);
									//concepti->resetInitialTime();
									actualInstant->setConcept(concepti->getIndexInInstant(),concepti->geActualIndex());
								}
						}
					/*
					* this method locates the new actual concept
					* @param next, if has to locate the actual concept to the first concept that has next
					* next=true, else search for the first concept that has previous
					*/
					template<class P>
					void InstantHandler<P>::toLocateActualConcept(bool next)
						{
								int size=getSizeConceptsToChange();
								if(next)
									{
										
										if(actualConcept)
											{
												bool hasNextIndex=actualConcept->hasNextIndex();
												int position=actualConcept->getPosition();
												while( (position-1)>=0 && !hasNextIndex)
													{
														actualConcept=conceptsToChange[position-1];	
														hasNextIndex=actualConcept->hasNextIndex();
														position=actualConcept->getPosition();
													}
											}
										else
											{	
												if(size>0)
													actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
											}
									}
								else
									{
										if(actualConcept)
											{
												bool hasPreviousIndex=actualConcept->hasPreviousIndex();
												int position=actualConcept->getPosition();
												while( (position-1)>=0 && !hasPreviousIndex)
													{
														actualConcept=conceptsToChange[position-1];	
														hasPreviousIndex=actualConcept->hasPreviousIndex();
														position=actualConcept->getPosition();
													}
											}
										else
											{	
												if(size>0)
													actualConcept=conceptsToChange[getSizeConceptsToChange()-1];
											}
									}
						
						}
                  
                  
                  
