/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

//	MACRO
#ifndef __READERENVIRONMENT_H_INCLUDED__
#define __READERENVIRONMENT_H_INCLUDED__

// SYSTEM INCLUDES

// PROJECT INCLUDES
#include <map>
#include <iostream>
#include <string>
#include <fstream>

// LOCAL INCLUDES
//#ifndef __INSTANTHANDLER_H_INCLUDED
#include "InstantHandler.h"
//#endif

// FORWARD REFERENCES

/*
*	COMMENT
*	@param
*	@return
*/



template<class T>
class ReaderEnvironment
		{
				public:

					//=========== CONSTANTS ==============
					 std::string NUMCONCEPTS;
					 std::string CONCEPT;
					 std::string OBJECT;
					 std::string NUMOBJECTS;
					 std::string NAME;
					 std::string SIZE;
					 std::string PATH;
					 std::string INSTANT;
					 std::string NUMINSTANTS;
					 std::string RANGE;
					 std::string COMMENT;
					 std::string EQUAL;
					 std::string POINT;
					 std::string ALL;

					//====== LIFECYCLE ========
					
					ReaderEnvironment(std::string nameConfigurationFile,std::map<std::string,T>* things);
					ReaderEnvironment(std::string nameConceptFile,std::string nameObjectFile,std::map<std::string,T>* things);
					ReaderEnvironment(std::string nameOtherConceptsFile, std::string nameConceptFile,std::string nameObjectFile, std::map<std::string,T>* things);
					~ReaderEnvironment();
						
					//====== OPERATIONS =======
					/*
					* @return environment builded
					*/
					SomeEnvironment<T>* getEnvironment();
					
					//====== ACCESS ==========
				
						

				private:
					
					//======= ATTRIBUTES=======
					/*
					*	Environment
					*/
					SomeEnvironment<T>* environment;
					/*
					* things of the environment
					*/
					std::map<std::string,T>* things;
					/*
					* name of the configuration file 
					*/
					std::string nameConfigurationFile;
					/*
					* name of the configuration file for the objects
					*/
					std::string nameObjectFile;
					/*
					*  name of the configuration file for the concepts
					*/
					std::string nameConceptFile;
					/*
					*  name of the configuration file for other concepts
					*/
					std::string nameOtherConceptsFile;

					/*
					*  data in the file
					*/
					std::map<std::string,std::string> dataInFile;
					/*
					* instant handler
					*/
					InstantHandler<T>* instantHandler;
					/*
					* concepts number count
					*/
					int numberOfConcepts;

					
					//======== PRIVATE METHODS ==========
					/*
					* build the environment
					*/	

					void buildEnvironment();
					/*
					* read the configuration file
					*/
					void readFile(std::string nameFile);
					
					/*
					* add the concepts of the file to the environment
					*/
					bool addConcepts();
					/*
					* adds the things to the  environment
					*/
					bool addThings();
					/*
					*	add the instants defined in the file for the name of the
					*	object given
					*	@param nameObject, name of the object for which we want to search
					*	its instant
					*/
					bool addInstantToThing(std::string nameObject,std::string index);
					/*
					*	build the instant from the string readed in the file
					*	@param instant, string with the description of the instant
					*	@param nameObject, name of the object for wich we can add an instant or several instants
					*	@return 
					*/
					bool addInstants(std::string nameObject,std::string instant);
					/*
					*	Returns the instant object of the instant string given
					*	1 1 1 1 and returns an instant object (1,1,1,1)
					*	@param instant, instant for which  we want to construct an Instant object
					*/
					Instant* getInstant(std::string instant);
					/*
					*	Returns the number of the concept in the instant string read
					*	@param instant,instant where we are going to search the number of the
					*	concept that is in the position given
					*	@param position, position of the concept for which we want the number in the instant given
					*/
					int getNumConcept(std::string& instant,int position  );
					/*
					*	Returns the name of the concept in the concepts defined given the number 
					*	of the concept in the instant
					*	@param nameConcept, string where is going to be load the name of the concept
					*	@param numConcept, number of the concept in the instant for which we are looking
					*	for the name
					*/
					
					void  getConceptName(std::string& nameConcept,int numConcept);

					/*
					* Returns the number of decimals places of the number given
					*/
					int getNumberOfDecimalPlaces(int number);

					/*
					* Clean the line readed from the file
					*/
					void cleanLine(std::string & line);
					
					

	};
//include the implementation of the template
#include "ReaderEnvironment_Txx.h"
#endif


	
