/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


// SYSTEM INCLUDES

#include <map>

// PROJECT INCLUDES


// LOCAL INCLUDES



// FORWARD REFERENCES

//NAMESPACE

               //====== LIFECYCLE ========
 template<class T>         
SomeEnvironment<T>::SomeEnvironment()
{
}
template<class T>   
SomeEnvironment<T>::SomeEnvironment(std::map<std::string,int>* concepts,std::map< std::string,SomeThing<T> >* things)
{
   this->concepts=concepts;
   this->things=things;
}

template<class T>   
SomeEnvironment<T>::~SomeEnvironment()
   {
      int size,i;
      
      //deleting existing instants
      size=existingInstants.size();
      for(i=0;i<size;i++)
         delete existingInstants[i];
      existingInstants.clear();
      //deleting concepts   
      concepts.clear();
      //deleting things
      things.clear();
      //indexes of concept
      indexesConcepts.clear();
      //things of instant
      thingsOfInstant.clear();
   }
               
//====== OPERATIONS =======
/*
*   Adds a thing to the program
*   @param name: name of the thing
*   @param thing: thing to be added
*   @return true if the thing was succesfully added
*/

template<class T>   
bool SomeEnvironment<T>:: addThing(std::string name,T thing)
   {
      SomeThing<T> something (name);
      something.setThing(thing);
      things.insert(std::pair < std::string, SomeThing<T> >(name,something));
      return true;
   }

/*
*   Add thing with the name given to the instant given
*   PRECONDITION
*   the thing that has that name IS ALREADY ADDED TO THE PROGRAM
*   @param name: name of the EXISTANT thing
*   @param instant: instant associated to the thing
*   @return true if the thing was succesfully added
*/
template<class T>   
bool SomeEnvironment<T>::addInstantToThing(std::string name,Instant* instant)
   {
      typename std::map< std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.find(name);
      if(thingsIterator != things.end())
      {
          SomeThing<T>* something=&thingsIterator->second;
         //getting the address of the instant added to the environment
         // in the existing instants; EVERYTHING IS HANDLED INSIDE
         
          //saving instants
          int indexInstantInside=addInstant(instant);
          //borrame
          //int indexInstantInside=getIndexInstantInExistingInstants(instant);
          Instant* instantInExistingInstants=NULL;
          if(indexInstantInside!=-1)
             {
               instantInExistingInstants=existingInstants[indexInstantInside];
               something->addInstant(instantInExistingInstants);
               return true;
             }
          return false;
      }
      return false;
   }
/*
*   Add thing with the name given, and the data given in the instant given
*   @param name: name of the thing
*   @param thing: information of the thing to be added
*   @param instant: instant associated to the thing
*   @return true if the thing was succesfully added
*/
template<class T>   
bool SomeEnvironment<T>::addThingWithInstant(std::string name,T thing,Instant* instant)
   {
      SomeThing<T> something(name);
      something.setThing(thing);
      //saving instants
      int indexInstantInside=addInstant(instant);
      //borrame
      //int indexInstantInside=getIndexInstantInExistingInstants(instant);
      if(indexInstantInside!=-1)   
      {
         Instant* instantInExistingInstants = existingInstants[indexInstantInside];
         something.addInstant(instantInExistingInstants);
         things.insert(std::pair< std::string, SomeThing<T> >(name,something));
         return true;
      }
      return false;
   }
/*
*   Add a concept to the environment
*   @param name: name of the concept
*   @param size: size of the concept, it means that its indexes are
*             distributed 0..size-1
*   @return true if succesful, false otherwise
*/

template<class T>   
bool SomeEnvironment<T>::addConcept(std::string name, int size)
   {
      concepts.insert(std::pair< std::string,int >(name,size));
      int sizeMap=concepts.size();
      indexesConcepts.insert(std::pair< std::string,int >(name,sizeMap-1));
      return true;
   }
/*
* Validate the index of a concept in an instant
*/
template<class T>
bool SomeEnvironment<T>::isValidIndex(int index, int indexInInstant)
   {
      std::map<std::string,int>::iterator conceptsIterator=concepts.begin();
      std::map<std::string,int>::iterator conceptsIndexesIterator;
      std::string conceptNamei;
      int indexInInstantConcepti,size;
      while(conceptsIterator!=concepts.end())
         {
            conceptNamei=conceptsIterator->first;
            size=conceptsIterator->second;
            indexInInstantConcepti=getIndexConcept(conceptNamei);
            if(indexInInstantConcepti==indexInInstant)
               {
                if(index<size)
                   return true;
                else
                   return false;
               }
            conceptNamei.clear();
            conceptsIterator++;
         }
      return false;
   }

//====== INQUIRY =========

template<class T>   
std::vector<T*>* SomeEnvironment<T>::getThings(Instant* instant)
   {
      //cleaning things of instant
      thingsOfInstant.clear();
      //
      
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator = things.begin();
      //setting the environment instant
      int indexInstantInside=getIndexInstantInExistingInstants(instant);
      Instant* instantInExistingInstants=NULL;
      if(indexInstantInside!=-1)
         {   
            instantInExistingInstants=existingInstants[indexInstantInside];
      
            while(thingsIterator!=things.end() && instantInExistingInstants)
               {
                  SomeThing<T>* something=&thingsIterator->second;

                  bool isInInstantB=isInInstant(something,instantInExistingInstants);
                  if(isInInstantB)
                  {
                     T* thing=something->getThing();
                     thingsOfInstant.push_back(thing);
                  }   
                  thingsIterator++;
               }
         }
      return &thingsOfInstant;
   }

/*
*   Returns the things with their names in the environment
*   @param names, vector where is goint to be safe the names 
*   of the things in the environment.
*   @param things, vector where is going to be save the things
*   @return
*/
template<class T>   
void SomeEnvironment<T>::getThings(std::vector< std::string >& names,std::vector< T* >& thingsVector, Instant* instant)
   {
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.begin();
      //setting the environment instant
      int indexInstantInside=getIndexInstantInExistingInstants(instant);
      Instant* instantInExistingInstants=NULL;
      if(indexInstantInside!=-1)
      {   
         instantInExistingInstants=existingInstants[indexInstantInside];
      
         while(thingsIterator!=things.end() && instantInExistingInstants)
            {
               SomeThing<T>* something=&thingsIterator->second;
               bool isInInstantB=isInInstant(something,instantInExistingInstants);
               if(isInInstantB)
               {
                  std::string nameThingInEnvironment=thingsIterator->first;
                  T* thing=something->getThing();
                  thingsVector.push_back(thing);
                  names.push_back(nameThingInEnvironment);
               }   
               thingsIterator++;
            }
      }
   }
/*
*   Returns the instants where the thing identified by the name
*   it should appears
*   @param nameThing, name of the thing in the environment
*   @return instants of that thing
*/
template<class T>
std::vector<Instant*>* SomeEnvironment<T>::getInstantsOfThing(std::string nameThing)
   {
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.find(nameThing);
      if(thingsIterator!=things.end())
         {
            SomeThing<T>* something=&thingsIterator->second;
            return something->getInstants();
         }
      return (std::vector<Instant*>*)NULL;
   }

/*
*   Returns the instants define in the environment
*   @return existing instants in the environment
*   A POINTER TO THE  EXISTINGINSTANTS
*/
template<class T>
std::vector<Instant*>* SomeEnvironment<T>::getExistingInstants()
   {
      return &existingInstants;
   }


/*
*   Returns the size of the concept identified by nameConcept
*   @param nameConcept, name of the concept in the environment
*   @return size, of the concept given or -1 if the concept doesnt
*   exist
*/
template<class T>
int SomeEnvironment<T>::getSizeConcept(std::string nameConcept)
   {
      std::map< std::string, int>::iterator conceptsIterator;
      conceptsIterator= concepts.find(nameConcept);
      if(conceptsIterator!= concepts.end())
       {
         return conceptsIterator->second;
       }
      else
         return -1;
   }
/*
* returns the index of the  concept in the instants
*/
template<class T>
int SomeEnvironment<T>::getIndexConcept(std::string nameConcept)
   {
      std::map< std::string, int>::iterator indexesConceptsIterator;
      indexesConceptsIterator= indexesConcepts.find(nameConcept);
      if(indexesConceptsIterator!= indexesConcepts.end())
       {
         return indexesConceptsIterator->second;
       }
      else
         return -1;
   }
/*
*   NEW
*   Give the names of the names defined
*   @param nameConcepts, vector where is goin to be save the names of the concepts
*/
template<class T>
void SomeEnvironment<T>::getConceptsNames(std::vector<std::string>& namesConcepts)
   {
      std::map<std::string,int>::iterator iteratorConcepts=concepts.begin();
      std::string nameConcept;
      while(iteratorConcepts!=concepts.end())
         {
            nameConcept=iteratorConcepts->first;
            namesConcepts.push_back(nameConcept);
            iteratorConcepts++;
         }
   }
/*
*   Method that retorns the name of each concept and the size of it.
*   @param conceptNameVect, Vector in which is disposed to be setted the name for each of the included concepts
*   @param conceptSizeVect, Vector in which is disposed to be setted the size for each of the included concepts
*/
template<class T>
void SomeEnvironment<T> :: getConceptsInformation(std::vector<std::string>& conceptNameVect, std::vector<int>& conceptSizeVect)
{
   std::map<std::string,int>::iterator iteratorConcepts=concepts.begin();   
   while(iteratorConcepts!=concepts.end())
      {
         std::string aName = iteratorConcepts->first;
         int aSize = iteratorConcepts->second;         
         conceptNameVect.push_back( aName );
         conceptSizeVect.push_back( aSize );
         iteratorConcepts++;
      }
}

/*
* returns all the things of the environment
*/
template<class T>
void SomeEnvironment<T>::getThingsOfEnvironment(std::vector<T*>* thingsVector)
   {
      typename std::map<std::string, SomeThing<T> >::iterator iteratorThings= things.begin();
      thingsVector->clear();
      while(iteratorThings!=things.end())
         {
            SomeThing<T>* something=&iteratorThings->second;
            T* thing=something->getThing();
            thingsVector->push_back(thing);
            iteratorThings++;
         }
   }
/*
* returns a pointer to the thing with the name given
*/
template<class T>
T* SomeEnvironment<T>::getThingByName(std::string name)
   {
      T* thing=NULL;
      typename std::map<std::string, SomeThing<T> >::iterator iteratorThings= things.find(name);
      if(iteratorThings!=things.end())
         {
            SomeThing<T>* something=&iteratorThings->second;
            thing=something->getThing();
         }
      return thing;
   }


/*
* returns the number of concepts defined
*/
template<class T>   
int SomeEnvironment<T>::getNumberOfConcepts()
   {
      return this->concepts.size();
   }

   /*
* Gets the number of things 
* @return Returns the number of existing things in the environment
*/
template<class T>
int SomeEnvironment<T>::getNumberOfThings ()
   {
      return things.size();
   }
   

//====== ACCESS ==========
/*
*   Remove a thing from all the instants, it means from the program
*   @param name: name of the thing
*   @return: true if the removed is succesful (false if the thing doesn exist)
*/
template<class T>   
bool SomeEnvironment<T>::removeThing(std::string name)
   {
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.find(name);
      if(thingsIterator!=things.end())
         {
            things.erase(thingsIterator);
            return true;
         }
      return false;
   }
/*
*   Removes the thing with the name given, from the instant
*   given
*   @param name: name of the thing
*   @param Instant: Instant from which it will be removed
*   @return true: if the removed is succesful (false if the thing doesn exist)
*/
template<class T>   
bool SomeEnvironment<T>::removeThingFromInstant(std::string name, Instant* instant)
   {
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.find(name);
      //setting the environment instant
      int indexInstantInside=getIndexInstantInExistingInstants(instant);
      Instant* instantInExistingInstants=NULL;
      if(indexInstantInside!=-1)
         instantInExistingInstants=existingInstants[indexInstantInside];
            
      if(thingsIterator!=things.end() && instantInExistingInstants)
         {
            SomeThing<T>* something=&thingsIterator->second;
            
            bool isInInstantB=isInInstant(something,instantInExistingInstants);
            if(isInInstantB)
               {
                  something->removeInstant(instant);
                  return true;
               }
         }
      return false;
   }

/*
*   Remove Instant from the program, it means, that from all the
*   somethings that have that instant, after call this method them 
*   doesnt have that instant anymore
*   @param instant: instant that is going to be removed
*   @return true: if the removed is succesful (false other wise)
*/
template<class T>   
bool SomeEnvironment<T>::removeInstant(Instant* instant)
   {
      typename std::map < std::string,SomeThing<T> >::iterator thingsIterator;
      thingsIterator=things.begin();
      bool ok=false;
   
      //setting the environment instant
      int indexInstantInside=getIndexInstantInExistingInstants(instant);
      Instant* instantInExistingInstants=NULL;
      if(indexInstantInside!=-1)
         instantInExistingInstants=existingInstants[indexInstantInside];
      
      while(thingsIterator!=things.end() && instantInExistingInstants)
         {
            SomeThing<T>* something=&thingsIterator->second;
            bool isInInstantB=isInInstant(something,instantInExistingInstants);
            if(isInInstantB)
               ok = something->removeInstant(instantInExistingInstants);
            thingsIterator++;
            
         }
      //removing from inside instants
      removeInstantFromExistingInstants(instant);
      return ok;
   }
/*
*   Remove a dimension from the environment
*   THE REMOVE OF THE CONCEPT IS WHEN IS BEING DEFINED THE ENVIRONMENT ,NO IN
*   EXECUTION
*   PRECONDITION
*   the name of the concept given is already added to the environment
*   @param nameConcept, name of the concept to remove
*/
template<class T>      
bool SomeEnvironment<T>::removeConcept(std::string nameConcept)
   {
      std::map < std::string,int >::iterator conceptsIterator;
      conceptsIterator=concepts.find(nameConcept);
      if(conceptsIterator!=concepts.end())
         {
            concepts.erase(conceptsIterator);
            return true;
         }
      return false;
   }
//====== PRIVATE METHODS=========
/*
*   Checks if in the instant given the something given has it
*   @param instant, instant to check
*   @param something;, something to check in the instant
*   @return
*/
template<class T>   
bool SomeEnvironment<T>::isInInstant(SomeThing<T>* something,Instant *instant)
{
   //borrame
   for(int i=0;i<instant->getSize();i++)
      /// \TODO fix warning unused variable k
      int k=instant->getIndexInConcept(i);
   //         
   int index=something->hasInstant(instant);
   if(index!=-1)
      return true;
   else
      return false;
}
/*
*   Remove the instant from the environment
*   @param instant, to be erased
*   @return
*/
template<class T>   
void  SomeEnvironment<T>::removeInstantFromExistingInstants(Instant* instant)
   {
      std::vector<Instant*>::iterator existingInstantsIterator=existingInstants.begin();
      bool isEquals=false;
      while(existingInstantsIterator!=existingInstants.end()&& !isEquals)
         {
            isEquals=(*existingInstantsIterator)->isEquals(instant);
            if(isEquals)
               existingInstants.erase(existingInstantsIterator);
            existingInstantsIterator++;
         }
   }

/*
*   Adds an instant to the existing instants, verifying if
*   the instant is already added
*   @param instant, to be added
*   @return
*/
template<class T>   
int SomeEnvironment<T>::addInstant(Instant* instant)
   {
      std::vector<Instant*>::iterator existingInstantsIterator=existingInstants.begin();
      int i=0;
      bool isEquals=false;
      while(existingInstantsIterator!=existingInstants.end() && !isEquals)
         {
            Instant* existingInstant=*existingInstantsIterator;
            //borrame
            int sizeI=existingInstant->getSize();
            for(int k=0;k<sizeI;k++)
            /// \ TODO fix warning unused variable r
               int r=existingInstant->getIndexInConcept(k);
            //
            isEquals=existingInstant->isEquals(instant);
            existingInstantsIterator++;
            if(!isEquals)
               i++;  
         }
      if(!isEquals)
         {
            //copying the instant's information
            std::vector<int>* instantVector=new std::vector<int>();
            int sizeInstant=instant->getSize();
            int k;
            for(k=0;k<sizeInstant;k++)
               {
                 int d=instant->getIndexInConcept(k);
                 instantVector->push_back(d);
               }
            //
            //saving the instant given in the handler
            Instant* instantToAdded= new Instant(instantVector);
            existingInstants.push_back(instantToAdded);
            i=existingInstants.size()-1;
         }
      return i;
   }
/*
*   Return the index in the existing instants of the instant 
*   that the user had given
*   @param instant, instant for which we are looking the index in
*   the  existings intants in the environment
*   @return an index in (0,existingInstants.size()-1)or -1 if the instant hasnt
*   being defined
*/
template<class T>   
int SomeEnvironment<T>::getIndexInstantInExistingInstants(Instant* instant)
   {
      std::vector<Instant*>::iterator existingInstantsIterator=existingInstants.begin();
      int i=0;
      bool isEquals=false;
      while(existingInstantsIterator!=existingInstants.end() && !isEquals)
         {
            isEquals=(*existingInstantsIterator)->isEquals(instant);
            existingInstantsIterator++;
            if(!isEquals)
               i++;
         }
      if(!isEquals)
            return -1;
      else
            return i;
   }
