/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

//	MACRO

#ifndef __SOMETHING_H_INCLUDED__
#define  __SOMETHING_H_INCLUDED__

// SYSTEM INCLUDES

// PROJECT INCLUDES

#include <vector>
#include <iostream>

// LOCAL INCLUDES
#include "Instant.h"


// FORWARD REFERENCES

/*
*	COMMENT
*	@param
*	@return
*/




template <class U>
class SomeThing
		{
				public:
					

					//====== LIFECYCLE ========
					
					SomeThing(std::string name);
						
					
					~SomeThing();
						
					

					//====== OPERATIONS =======
					
					/*
					*	Add a new instant to the thing
					*	@param instant: new instant
					*/
					
					bool addInstant(Instant* instant);
					

					//====== INQUIRY =========
					/*
					*	Get the thing stored
					*	@return thing
					*/
					
					U* getThing();
						
					/*
					*	Get the name of the thing
					*	@return nameThing
					*/
					
					std::string getName();
						
					/*
					*	Get all the instants
					*	@return instants
					*/
					
					std::vector<Instant*>* getInstants();
						
					/*
					*	Get the instant that's in the index given
					*	@param indexInstant: index of the instant that they want
					*	@return instants[instantIndex]
					*/
					
					Instant* getInstant(int indexInstant);
						
					/*
					*	Get the number of instants that the 
					*	thng has.
					*	@return instants.size()
					*/
				
					int  getNumberInstants();
						
					/*
					*  if this is in the instant given
					*  @param instant: instant to verified if this has it
					*  @return  0<=i<numberOfInstants if this has the instant, -1 otherwise
					*/
				
					int hasInstant(Instant* instant);
						
					//====== ACCESS ==========
					/*
					*	Set the thing
					*	@param U* thing
					*/
				
					void setThing(U thing);
						
					/*
					*	Set the name of the thing
					*	@param nameThing
					*/
					
					void setName(std::string name);
						
					/*
					*	Set the instants of the thing
					*	@param instants
					*/
					
					void setInstants(std::vector<Instant*> instants);
						
					/*
					*	Remove an instant from the thing
					*	@param indexInstant: index of the instant to be removed
					*	@return true if succesful , false otherwise
					*/
				
					bool removeInstant(int indexInstant);
						
					/*
					*	Remove an instant from the thing
					*	@param instant: instant to be deleted
					*	@return true if succesful , false otherwise
					*/
				
					bool removeInstant(Instant* instant);
						

				private:
					
					//======= ATTRIBUTES=======
					/*
					*	name of the something
					*	WARNING 
					*	has to be different from the
					*   other existing somethings in the program 
					*	using the handler
					*/
					std::string nameThing;
					/*
					*	the thing that we are handling
					*	it could be any object
					*/
					U thing;
					/*
					*	instants that the thing
					*	has defined
					*/
					std::vector<Instant*> instantsVector;
					
	};
//include the implementation of the template
#include "SomeThing_Txx.h"
#endif


	
