/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



// SYSTEM INCLUDES
/*
	#include <vector>
	#include <iostream>
*/
// PROJECT INCLUDES

//#include "Instant.h"

// LOCAL INCLUDES


// FORWARD REFERENCES

/*
*	COMMENT
*	@param
*	@return
*/

					//====== LIFECYCLE ========
					template <class U>
					SomeThing<U>::SomeThing(std::string name)
						{
							nameThing=name;
						}
			
					template <class U>
					SomeThing<U>::~SomeThing()
						{
							
							instantsVector.clear();
							nameThing.clear();
							
						}
					

					//====== OPERATIONS =======
					
					/*
					*	Add a new instant to the thing
					*	@param instant: new instant
					*/
					template <class U>
					bool SomeThing<U>::addInstant(Instant* instant)
						{
							//borrame 
							int sizeInstant=instant->getSize();
							for(int i=0;i<sizeInstant;i++)
                                                                /// \TODO fix warning unused variable j
								int j=instant->getIndexInConcept(i);
							//
							int index= hasInstant(instant);
							if(index==-1)
								this->instantsVector.push_back(instant);
							return true;
						}

					//====== INQUIRY =========
					/*
					*	Get the thing stored
					*	@return thing
					*/
					template <class U>
					U* SomeThing<U>::getThing()
						{
							return &thing;
						}
					/*
					*	Get the name of the thing
					*	@return nameThing
					*/
					template <class U>
					std::string SomeThing<U>::getName()
						{
							return nameThing;
						}
					/*
					*	Get all the instants
					*	@return instants
					*/
					template <class U>
					std::vector<Instant*>* SomeThing<U>::getInstants()
						{
							return &instantsVector;
						}
					/*
					*	Get the instant that's in the index given
					*	@param indexInstant: index of the instant that they want
					*	@return instants[instantIndex]
					*/
					template <class U>
					Instant* SomeThing<U>::getInstant(int indexInstant)
						{
							return instantsVector[indexInstant];
						}
					/*
					*	Get the number of instants that the 
					*	thng has.
					*	@return instants.size()
					*/
					template <class U>
					int  SomeThing<U>::getNumberInstants()
						{
							return this->instantsVector.size();
							
						}
					/*
					*  if this is in the instant given
					*  @param instant: instant to verified if this has it
					*  @return  0<=i<numberOfInstants if this has the instant, -1 otherwise
					*/
					template <class U>
					int SomeThing<U>::hasInstant(Instant* instant)
						{
						  int i;
						  int sizeInstants=this->getNumberInstants();
						  bool isEquals=false;	
						  for(i=0;i<sizeInstants;i++)
								{
									Instant* instanti=this->getInstant(i);
									isEquals=instanti->isEquals(instant);
									if(isEquals)
										return i;
								}
						 return -1;
						}
					//====== ACCESS ==========
					/*
					*	Set the thing
					*	@param U* thing
					*/
					template <class U>
					void SomeThing<U>::setThing(U thing)
						{
							this->thing=thing;
						}
					/*
					*	Set the name of the thing
					*	@param nameThing
					*/
					template <class U>
					void SomeThing<U>::setName(std::string name)
						{
							this->nameThing=name;
						}
					/*
					*	Set the instants of the thing
					*	@param instants
					*/
					template <class U>
					void SomeThing<U>::setInstants(std::vector<Instant*> instants)
					{
						this->instantsVector=instants;
					}
					/*
					*	Remove an instant from the thing
					*	@param indexInstant: index of the instant to be removed
					*	@return true if succesful , false otherwise
					*/
					template <class U>
					bool SomeThing<U>::removeInstant(int indexInstant)
						{
							int i;
							std::vector<Instant*>::iterator instantsIterator=this->instantsVector.begin();
							int sizeInstants=this->getNumberInstants();
							for(i=0;i<sizeInstants;i++)
								{
									if(i==indexInstant)
									{
										this->instantsVector.erase(instantsIterator);
										return true;
									}
									instantsIterator++;
								}
							return false;
						}
					/*
					*	Remove an instant from the thing
					*	@param instant: instant to be deleted
					*	@return true if succesful , false otherwise
					*/
					template <class U>
					bool SomeThing<U>::removeInstant(Instant* instant)
						{
							int index=hasInstant(instant);
							if(index!=-1)
								{
									removeInstant(index);
									return true;
								}
							return false;
						}
                  
                  
