/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

namespace creaImageIO
{
	/**
	* \ingroup View
	*/
    //=====================================================================
    
    //=====================================================================
    ///Abstract class that handles views, attributes and previews (GUI) for Gimmick.
	class GimmickView
    {
    public:
      /// Ctor
      GimmickView();
      /// Virtual destructor
      virtual ~GimmickView();

  	//====================================================================
	// General
	//====================================================================

    /// Returns the size of the current selection
    virtual int GetSelectionSize() { return 0; } 
    /// Returns true if there is a valid selection
    virtual bool IsSelectionValid(){ return false; }
    /// Returns the vector of full filenames of selected images
    virtual void GetSelectedFiles(std::vector<std::string>&){ return; }
    /// Returns the vector of images corresponding to selection
    virtual void GetSelectedImages(std::vector<vtkImageData*>&){ return; }
    /// Returns the vector of DicomNode corresponding to selection
    virtual void GetSelectedDicomNodes(std::vector<DicomNode*>&){ return; }
   /// Returns the DicomNode corresponding to the tree item
    virtual DicomNode* GetDicomNodeOfItem(const TreeItemId& i);

	
	/// Type of list of DicomDatabase
    typedef std::vector<DicomDatabase*> DicomDatabaseListType;
    /// Returns the list of DicomDatabase open
    virtual DicomDatabaseListType& GetDicomDatabaseList() 
    { return null; }
    /// Returns the list of DicomDatabase open (const)
    virtual const DicomDatabaseListType& GetDicomDatabaseList() const 
    { return null; }

	protected:
	///Opens an existing database, or else, creates a local database.
    virtual void OpenOrNewDatabase(bool open){ return; }
	///Shows the help
	virtual void ShowHelp();

	private:
	///Gets the extension of the database
	const std::string& GetDatabaseExtension() { return null; }
	///Sets the extension of the database
    virtual void SetDatabaseExtension(const std::string& ext){ return; }


	//====================================================================
    // Preview Display Related
	//====================================================================


    ///Shows the image sent as a parameter
	private:
	 virtual void ShowImage(vtkImageData* image){ return; }

	//====================================================================
    // Favorites Related
	//====================================================================


	public:
	///Loads or creates a favorites database
    virtual void LoadOrCreateFavoritesDatabase(){ return; }
	private:
	///Creates the user settings directory
    void CreateUserSettingsDirectory(){ return; }
	///Obtains the user settings directory
	const std::string& GetUserSettingsDirectory(){ return null; }

	//====================================================================	
	// Attribute Display Related
	//====================================================================


	///Shows the Information regarding the node sent as a parameter
	private:
     virtual void ShowInformation(DicomNode*){ return; }
   
	//====================================================================
    // Tree Display Related
    //====================================================================

	protected:
    /// Completely rebuilds the view with 
    /// current DicomDatabaseList
    virtual void RebuildView(){ return; }
	/// Recursively updates the part of the view corresponding 
    /// to the DicomDatabase passed
    /// i.e. creates items for the DicomNode which do not have
    ///      deletes obsolete items (whose DicomNode has been deleted)
    virtual void UpdateDicomDatabaseView(DicomDatabase*){ return; }
    /// Recursively updates the part of the view corresponding 
    /// to the DicomNode provided.
    /// parent is its parent in the tree (where to insert / remove it)
	virtual void UpdateDicomNodeView(DicomNode* n, const TreeItemId& parent){ return; }
    
	private:
	///Type definition of the data regarding the tree
    typedef WxGimmickTreeItemData TreeItemData;
	///Gets the item data of the tree item passed as a parameter
    TreeItemData* GetItemData(const TreeItemId& id){ return null; }
    ///Type definition of the data insid a node of the tree
    typedef WxGimmickDicomNodeData NodeData;


	//====================================================================
    // Class Attributes
    //====================================================================

	
	int mSelectionType;
    int mSelectionMaxImageDimension;
    int mCurrentSelectionImageSize[4];

	///Existent Database List
    DicomDatabaseListType mDicomDatabaseList;
	///Favorites database
    DicomDatabase* mFavoriteDatabase;

	///Path to the database list file
    std::string mDatabaseListFile;
	///Extension of the database
    std::string mDatabaseExtension;

    bool mJustStarted;

    int  mFirstDicomDatabaseIconIndex;

   // Previewer
    vtkImageViewer2* mViewer;
    
    int mx1,mx2,my1,my2,mz1,mz2;
    double mspx,mspy,mspz;
  
    // Image preview :
    // Multi-thread image reader
    MultiThreadImageReader mReader;
    // map of images name to node
    std::map<std::string,DicomNode*> mImageFileNameToNode;
  
    //Controller which manages the interaction with the model
	Gimmick* controller;

    };
    // EO class GimmickView
    //=====================================================================
  
} // EO namespace creaImageIO

// EOF
#endif  