/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOListener_h_INCLUDED__
#define __creaImageIOListener_h_INCLUDED__

#include <creaImageIOSystem.h>
#include <stdio.h>
#include <time.h>
#include <wx/thread.h>
// Signal/slot mechanism
#include <boost/signals2/signal.hpp>
#include <boost/bind.hpp>
#include <boost/thread/mutex.hpp>

namespace creaImageIO
{

  class Listener : public wxThread
  {
  public:
    /// Ctors 
    Listener();
    /// Dtor
    virtual ~Listener();
	///Thread method that is executed once create is called
	void* Entry();
	///Thread method called upon exiting
    void  OnExit();
	///Sets the new state of adding files
	void SetAddFilesState(bool addFiles){boost::mutex::scoped_lock lock(mMutex);mAddFiles=addFiles;}
	///Sets the new state of removing files
	void SetRemoveFilesState(bool removeFiles){boost::mutex::scoped_lock lock(mMutex);mRemoveFiles=removeFiles;}
	///Sets the new monitored drive
	void SetMonitoredDrive(const std::string& dr){boost::mutex::scoped_lock lock(mMutex);mDrive=dr;}
	///Puts the name of the monitored drive in the given string
	void GetMonitoredDrive(std::string& drive){drive=mDrive;}

	///Related with signals
	//=============================================
    typedef boost::signals2::signal<void (bool)>  MountingSignalType;
    typedef MountingSignalType::slot_function_type MountingCallbackType;
    //=============================================

    //==================================================================
    void ConnectObserver(MountingCallbackType callback);
    //==================================================================

	///Sends a boost::signal to alert that the drive has changed its state (mounted/unmounted)
	void SendSignal(bool ivalid);
  

  private:
    /// The mutex
    boost::mutex mMutex;
    /// Boolean that declares if the files that are read on CD mount should be added
    bool mAddFiles;
	/// Boolean that declares if, on CD unmount, the files that were in the drive should be removed
    bool mRemoveFiles;
	///Boolean that declares if a unit has been mounted
	bool mMounted;
	///The monitored drive
	std::string mDrive;
	///The validation signal
	MountingSignalType mMountingSignal;
  };

}

#endif  
