/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOSynchronizer_h_INCLUDED__
#define __creaImageIOSynchronizer_h_INCLUDED__

#include <creaImageIOSQLiteTreeHandler.h>
#include <creaImageIOImageReader.h>

namespace creaImageIO
{

//=======================================================================
/// Synchronizes a given database with disk
class Synchronizer
  {
  public:
      /// Ctor
      Synchronizer(TreeHandler* th);
      /// Dtor
      ~Synchronizer();
	  ///Sets the tree handler to use in order to synchronize with a given database
	  void SetTreeHandler(TreeHandler * handler){mHandler=handler;}
	  ///Synchronizes the database in the current tree handler with disk by doing the passed action. If it is true,
	  ///the database will be updated, otherwise a warning message will be returned.
	  std::string Synchronize(bool update);
	  ///Checks if the file given as a parameter exists in the drive
	  bool FileExists(std::string file);
	  ///Checks if the attributes of the node given as a parameter matchwith it correspondent file in disk 
	  ///NB: This method doesn't check the existence of the file, so FileExists should be called before.
	  void AttributesMatch(bool update, std::string file, std::stringstream& mess);


  private:
	  ///The tree handler
	  TreeHandler* mHandler;
	  ///The image reader
	  ImageReader mReader;
	  ///Synchronizes the given file, doing the action required and returning the result on the string supplied
	  void SynchronizeFile(bool update, std::string file, std::stringstream& message);

  };
} // EO namespace creaImageIO

// EOF
#endif 