/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOTreeAttributeDescriptor_h_INCLUDED__
#define __creaImageIOTreeAttributeDescriptor_h_INCLUDED__

#include <creaImageIOSystem.h>
#include <string>
//#include <iostream>

namespace creaImageIO
{

  namespace tree
  {
	  /**
	* \ingroup Tree
	*/
    //=====================================================================
    /// Descriptor of an attribute of a node of a Tree (name, dicom group/element)
    class AttributeDescriptor
    {    
    public:
      /// Flags
      /// The attribute is hidden (not visible to user)
      static const unsigned int PRIVATE;
      /// The attribute enters in unique identifier constitution 
      static const unsigned int IDENTIFIER;
      /// The attribute enters in label constitution (for printing)
      static const unsigned int LABEL;
	   /// The attribute can be edited
      static const unsigned int EDITABLE;

	  /// Types
      /// The attribute is of numeric type
      static const int NUMBER=1;
      /// The attribute is of string type
      static const int STRING=2;
	  /// The attribute's type is unknown
      static const int UNKNOWN=0;

      /// Default ctor
      AttributeDescriptor()
	: mKey(""), mName(""), mGroup(0), mElement(0), mFlags(0)
      {
      }
      /// Ctor with all explicitely
      AttributeDescriptor(const std::string& key,
			  const std::string& name,
			  unsigned short group,
			  unsigned short element,
			  unsigned int flags)
	: mKey(key), mName(name), mGroup(group), mElement(element), 
	  mFlags(flags)
      {
      }

      // Ctor with key, name and flags
      AttributeDescriptor(const std::string& key,
			  const std::string& name,
			  unsigned int flags = 0);
      // Ctor with dicom group, elem and flags
      // The key is built as 'Dgroup_elem'
      // The user name is retreived from dicom dictionnary
      AttributeDescriptor(unsigned short group,
			  unsigned short element,
			  unsigned int flags = 0);
      /// Returns the key of the attribute
      const std::string& GetKey() const { return mKey; }
      /// Returns the name of the attribute
      const std::string& GetName() const { return mName; }
      /// Returns the DICOM group code of the attribute
      unsigned short GetGroup() const { return mGroup; }
      /// Returns the DICOM element code of the attribute
      unsigned short GetElement() const { return mElement; }
      /// Returns the flags of the attribute
      unsigned int GetFlags() const { return mFlags; }
	  
      /// Extracts group and element from a key of the form "Dgroup_elem" 
      static void GetDicomGroupElementFromKey(const std::string& key,
					      unsigned short& group,
					      unsigned short& elem);
      /// Cleans the name:
      /// Replace simple quote by double quotes
      /// Cut string at NULL chars 
      void CleanName(std::string& str) const;
	  ///Decodes the type of attribute into the existing ones
	  void DecodeType(unsigned int& type) const;

	  /// Determines if Attribute is a date
	  bool isDateEntry() const;

	  /// Determines if Attribute is a time
	  bool isTimeEntry() const;

    private:
      std::string mKey;
      std::string mName;
      unsigned short mGroup;
      unsigned short mElement;
      unsigned int mFlags;
    };
    // EO class AttributeDescriptor
    //=====================================================================

   

  } // EO namespace tree

} // EO namespace creaImageIO





#endif // #ifndef __creaImageIOTreeAttributeDescriptor_h_INCLUDED__
