/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageWxAnySimpleDlg_h_INCLUDED__
#define __creaImageWxAnySimpleDlg_h_INCLUDED__

#include "creaImageIOSimpleView.h"
#include <creaWx.h>
#include <itkImageFileReader.h>
#include <boost/any.hpp>
#include <typeinfo>
#include "itkImageToVTKImageFilter.h"

namespace creaImageIO
{
 /**
 * \ingroup View
 */

    /// Simple Wxwidgets interface to select file(s) or directory or from creaImageIO database to display
//EED    class  __declspec(dllexport) WxAnySimpleDlg : public wxDialog
    class  CREAIMAGEIO_EXPORT WxAnySimpleDlg : public wxDialog
    {
    public:
         /// Ctor
           WxAnySimpleDlg( wxWindow *parent,  
               wxString i_title =_T(""),
               const std::string i_namedescp = "localdatabase_Descriptor.dscp",   
               const std::string i_namedb    = "Local Database"
           );

           ~WxAnySimpleDlg(){};

           void setExts(std::vector<std::string>);
           /// Callback to read file(s)
           void OnReadFile(wxCommandEvent& event);

          /// Callback to read directory, no recursive
           void OnReadDirectory(wxCommandEvent &event);
          
          /// Callback to select from creaImageIO database
           void OnReadGimmick(wxCommandEvent &event);

           /// return a vtkImageData vector of selected images, if available
           std::vector<vtkImageData*> getVtkImagesSelected() {return m_Vresults;}

           wxString getInfoImage();

           void set(bool i_dicom){m_dicom= i_dicom;}
           std::vector <boost::any>& getImagesSelected(){ return m_AnyImages;}
        
           // return the size of readed images
           std::vector</*const*/ size_t> getDims(){ return m_AnyDims;} // comment out const // JPR

           // return the type of readed images
           std::vector</*const */std::type_info *> getTypes(){ return m_AnyType;} // comment out const // JPR

           // get an Image on wanted type
	   /*
	   // strange compile error, commented out on Fred's advice // JPR
           template <typename TImage> 
           typename TImage::Pointer getImage(boost::any i_AnyImage)
           {
              typedef itk::Image<TImage> ImageOut;
              typename ImageOut::Pointer img = ImageOut::New();
              img = boost::any_cast< ImageOut::Pointer>(i_AnyImage);
              return img;
           }
           */

         // get the images on itk type defined by user
          template <typename TImage> 
          std::vector<typename TImage::Pointer>  getTemplatedImagesSelected()
          {
             std::vector<typename TImage::Pointer> imgs;
             std::vector<boost::any>::iterator it = m_AnyImages.begin();
             for(; it != m_AnyImages.end(); it++)
             {
                 imgs.push_back(boost::any_cast<TImage*> (*it));
             }
             return imgs;
          }
          bool AllSameType();
		  template <class TImage> 
		  void split3Din3Dvtk(TImage* i_Img)
		 {
			typedef itk::ImageToVTKImageFilter< TImage > ConnectorType;
			 typename ConnectorType::Pointer       connector = ConnectorType::New();
			 connector->SetInput(i_Img);
			connector->GetImporter()->SetDataScalarTypeToUnsignedChar();
			connector->Update();
			vtkImageData *im = vtkImageData::New();
			im->ShallowCopy(connector->GetOutput());
			im->Update();
			m_Vresults.push_back(im);
		 }

		  
        template <typename TImage> 
        void split4Din3Dvtk(TImage* i_Img);

 
    private:

        // strange compile error with gcc 4.5.1-4 //JPR        
        std::vector</*const*/ size_t>           m_AnyDims;   //comment out const JPR
        std::vector</*const*/ std::type_info *> m_AnyType;   //comment out const JPR
        std::vector<boost::any>                 m_AnyImages; //comment out const JPR
        std::vector<std::string> m_exts;
        std::string namedescp; 
        std::string namedb;
        wxString infoimage;
        std::string m_dir;


       bool m_dicom;
        /// interface to read data
        SimpleView m_view;
        void readImg(const std::string &i_name);
        void readDicomImg(const std::vector<std::string> &i_names);
        std::vector <vtkImageData*> m_Vresults;
         
        const size_t getNumberOfDimensions(const std::string &i_name);
        const std::type_info & getType(const std::string &i_name);
    };


}// namespace creaImageIO
#endif //__creaImageWxAnySimpleDlg_h_INCLUDED__
