/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxDescriptorPanel_h_INCLUDED__
#define __creaImageIOWxDescriptorPanel_h_INCLUDED__

#ifdef USE_WXWIDGETS
#include <creaWx.h>
#include <string>
#include <map>
#include <vector>
#include <creaImageIOWxGimmickView.h>
#include <wx/listctrl.h>
#include <wx/statline.h>


#define ID_DESCRIPTOR 1500
#define ID_LEVEL_CTRL	     ID_DESCRIPTOR+1
#define ID_LEVEL_ADD	     ID_DESCRIPTOR+2
#define ID_GR_CTRL	         ID_DESCRIPTOR+3
#define ID_EL_CTRL	         ID_DESCRIPTOR+4
#define ID_NAME_CTRL	     ID_DESCRIPTOR+5
#define ID_ATTRIBUTE_CTRL	 ID_DESCRIPTOR+6
#define ID_ATTRIBUTE_ADD	 ID_DESCRIPTOR+7
#define ID_REMOVE_ADD		 ID_DESCRIPTOR+8
#define ID_DSCP_APPLY		 ID_DESCRIPTOR+9

namespace creaImageIO
{

  /**
   * \ingroup GUI
   */
  //=====================================================================
 //=====================================================================
 /// Gimmick DB are based on descriptors with a tree structure .
 /// Each level contains attributes (DICOM or other) to identify data
 /// WxDescriptorPanel allows creation, modification and save of descriptors. 
 ///

  class WxDescriptorPanel : public wxDialog
  {
  public:
    WxDescriptorPanel();    
	WxDescriptorPanel(wxWindow *parent, const std::string path);
    ~WxDescriptorPanel();

	// Get file to load Descriptor
	const std::string& GetDescriptor(){ return m_DscpFile;}

  private :

    // WxControls
	wxTextCtrl *LevelCtrl;	//TextCtrl to enter level's name
	wxTextCtrl *GRCtrl;	// TextCtrl to enter DICOM Group value
	wxTextCtrl *ELCtrl;	// TextCtrl to enter DICOM element value
	wxTextCtrl *ResultCtrl;	//TextCtrl to visualize Descriptor
	wxComboBox *AttributeCombo; // Combox to choose Attribute values

	/// Add an attribute (DICOM or own) 
	void OnAddAttribute(wxCommandEvent& event);

	/// Add an attribute (DICOM or own)
	void onAddAttribute( const std::string &att, const std::string &name_att, std::string level = "");

	/// Add a Level 
	void OnAddLevel(wxCommandEvent& event);
	
	/// Add a Level 
	void onAddLevel(const std::string &level);

	/// Find a DICOM attribute from group and element values
	void OnDicomAttribute(wxCommandEvent& event);

	/// Remove a value (level or attribute)
	void OnRemove(wxCommandEvent& event);

	/// Create a new descriptor
	void OnNew(wxCommandEvent& event);

	/// Load an exsitant descriptor
	void OnLoad(wxCommandEvent& event);

	/// Save a descriptor
	void OnOK(wxCommandEvent& event);

	/// Save a descriptor and use it
	void OnApply(wxCommandEvent& event);

	/// Cancel
	void OnCancel(wxCommandEvent& event);

	/// Create a descriptor structure
	void CreateDescriptor(int type);

	/// add a level
	bool addLevel(const std::string &name);

	/// add an attribute
	bool addAtribute(const std::string &level, const std::string &name);

	/// remove an attribute
	bool RemoveAttribute(const std::string &level, const std::string &name);

	/// remove a level
	bool RemoveLevel(const std::string &name);

	/// Create a descriptor file
	void createDescriptorFile();
	
	/// load a descriptor file
	void loadDescriptor(const std::string i_name);

	/// find a level'name 
	std::string findLevel();

	/// determine values for own attributes
	std::string OwnAttribute(const std::string name);

	/// save a descriptor in a file
	const std::string saveDescriptor();

	/// number of level 
	int lv;

	/// Insert point in result control
	long InsertPt;

	/// Output file for Descriptor
	std::string m_DscpFile;

	/// Output Descriptor
	std::string outDscp; 
	
	// Vector of attributes
	std::vector<std::string> VLevel;

	// map of level, attributes
	std::map<std::string, std::vector<std::string> > DscpTree;

	// map of own application attributes
	std::map<std::string, std::string> ownatt;

	// List of added level
	std::map<int, std::string> lvlist;

	// DB Gimmick path
	std::string m_path;

  }; // class WxDescriptorPanel
  //=====================================================================

  
} // EO namespace creaImageIO


#endif // USE_WIDGETS
// EOF
#endif

