/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file 
 *  \brief Class ThresholdImageView . 
 */

/**
 * \class ThresholdImageView
 * \brief 
 */
 
#ifndef __ColorLayerImageView_h__
#define __ColorLayerImageView_h__

#include "LayerImageBase.h"


class  ColorLayerImageView : public LayerImageBase
  {
  public: 
	  ColorLayerImageView( );
	  ~ColorLayerImageView( );
	  void SetSliceFixDynamic(bool fix_dynamic);
	  void SetX2(int x2);
	  void SetY2(int y2);
	  void SetZ2(int z2);
	  virtual int GetX();
	  virtual int GetY();
	  virtual int GetZ();
	  
	  /** 
	   * \brief  Each color is described by its RGB coordinates. Therefore, the vector should have the size of a multiple of 3 elements.
	   *
	   * \param base_color the base color vector.
	   */
	  void SetBaseColors(std::vector<double> & base_color);
	  /** 
	   * \brief  Returns the base color for a given index (first coordinate of the first color being 1, second coordinate of the first color being 2, etc.).
	   *
	   * \param index for which we would like to get the base color.
	   * \return The corresponding base color value.
	   */
	  double GetBaseColors(unsigned int index);
	  /** 
	   * \brief The boundaries include the extrema. There must be one more element in this vector than GetBaseColorNb.
	   *
	   * \param grey_level_boundary the grey level boundary vector.
	   */
	  void SetGreyLevelBoundaries(std::vector<double> & grey_level_boundary);
	  /** 
	   * \brief  Returns the grey level boundary for a given index.
	   *
	   * \param index for which we would like to get the grey level boundary.
	   * \return The corresponding grey level value.
	   */
	  double GetGreyLevelBoundaries(unsigned int index);
	  /** 
	   * \brief Sets the color type. True for plain color, false for gradient color. Default is false.
	   *
	   * \param color_type the color type
	   */
	  void SetPlainOrGradientColor(bool color_type);
	  /** 
	   * \brief  Returns the number of base colors.
	   *
	   * \return The number of base colors.
	   */
	  int GetBaseColorNb();


		void 	FillColorTable(int start, int end, double r1, double g1, double b1, double r2, double g2, double b2);

		int 	GrayLevel_TO_colorTableIndex( double VALUE );


  private:

	  int _x2, _y2, _z2;
	  bool _fix_dynamic;
	  void SetDefaultGreyLevelBoundary();
	  void SetDefaultBaseColorAndGreyLevelBoundary();
	  virtual void ConfigLookupTable();
     int maxColorsThresholdTable;


	  //! Range values in the colored image.
	  double _range[2];

	  //! Base colors for the overlaid image.
	  std::vector<double> _base_color;
	  //! Grey level boundaries.
	  std::vector<double> _grey_level_boundary;
	  //! Color type (plain or gradient color).
	  bool _color_type;

  protected:
 };

#endif

