/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ContourExtractData_h_INCLUDED_H__
#define __ContourExtractData_h_INCLUDED_H__


#include "manualContourModel.h"
#include "marTypes.h"


  //--------------------------------------------------------------------------
  class creaMaracasVisu_EXPORT ContourExtractData 
  {
  public:
	ContourExtractData(bool imagesResults=false);
    ~ContourExtractData();

//----------------------------------------------------------------------
	void SetImage( vtkImageData* imagedata);
	void SetZtoBeAnalys( int z );

	void SetLstManualContourModel( std::vector<manualBaseModel*> lstManConMod);
	void GetValuesInsideCrown(	int *numberOfPixels,
								std::vector<double> *pLstValue,
								std::vector<double> *pLstValuePosX,
								std::vector<double> *pLstValuePosY,
								std::vector<double> *pLstValuePosZ);

	void CalculateImageResult();
	vtkImageData *GetVtkImageValueResult();
	vtkImageData *GetVtkImageMaskResult();
	void Statistics( std::vector<double> *inputLstValue, 
					int     grayRangeMin,
					int     grayRangeMax,
					int		*rCountRange, 
					int		*rsize, 
					double	*rmin, 
					double	*rmax,
					double	*raverage,
					double	*rstandardeviation);
	void SetTypeOperation(int type);

	  //--Volume Statistics--
	  void InitVolumeStatistics();
	  void GetVolumeStatistics(int *vol_rCountRange, int *vol_rsize,
								double *vol_minValue, double *vol_maxValue,
								double *vol_average, double *vol_standardeviation);
	  
	  void ResetImageResult(int z);
	  void SetScalarRange(double min, double max);
	  void InitLstContoursLinesYPoints();
	  bool isInside(int x, int y, int typeOperation );
	
	  //
	  // Asigns the sizeImageY.
	  // @param pSizeImageY - int
	  void SetSizeImageY(int pSizeImageY);
	  
  private:
	double								scalarRange[2];
	bool								okImagesResults;

	//
	// List of contours to obtain the respective statistics.
	//
	std::vector<manualBaseModel*>	lstManConMod;

	//
	// Operation Type (AND,OR,XOR...)
	//
	int									_typeOperation;

	int									zImage;
	vtkImageData						*imagedata;
	vtkImageData						*imagedataValueResult;
	vtkImageData						*imagedataMaskResult;

	//Size Y
	int _sizeImageY;
	
	//
	// Asigns the minimum and maximum points of the contour model in parameter.
	// @param *minPoint - int
	// @param *maxPoint - int
	// @param *manualcontourmodel - manualBaseModel
	//
	void GetMinMaxPoint(int *minPoint, 
						int *maxPoint, 
						manualBaseModel *manualcontourmodel );
	//
	// Obtain the minimum and maximum point among the contours. The value is saved in the parameter
	// pointers
	// @param *minPoint - int pointer to the minPoint
	// @param *maxPoint - int pointer to the maxPoint
	//
	void GetMinMaxPoint_Of_LstManConMod(	int *minPoint, 
											int *maxPoint);

	int AnalisisContourInsideV2(int x, int y, int iContour );
	  
	double GetDataValue(int x, int y, int z);
	void PutVtkImageDataResultValue( int x, int y,int z, double value );
	void InitVtkImagesResult();

	  //--Volume Statistics--
	  int		vol_rCountRange;
	  int		vol_rsize;
	  double	vol_minValue;
	  double	vol_maxValue;
	  double	vol_acum_average;
	  double	vol_acum_standardeviation;
	  void SetVolumeStatistics(int rCountRange, int rsize,
							   double minValue,double maxValue,
							   double acum_average, double acum_standardeviation);
	  
	  // Optimize IsInside
	  // List of contours , list of linesY, list of points over the line
	  std::vector< std::vector< std::vector<double> > >		_lstlstlstVecX1;
	  std::vector< std::vector< std::vector<double> > >		_lstlstlstVecY1;
	  std::vector< std::vector< std::vector<double> > >		_lstlstlstVecX2;
	  std::vector< std::vector< std::vector<double> > >		_lstlstlstVecY2;
	  void Fill_lstlstlstVecXY(int iContour, int sizeY);
	  


  };


#endif  // __ContourExtractData_h_INCLUDED_H__

