/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

Program:   wxMaracas
Module:    $RCSfile: CutModelMainPanel.h,v $
Language:  C++
Date:      $Date: 2012/11/15 14:16:20 $
Version:   $Revision: 1.6 $

Copyright: (c) 2002, 2003
License:

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __CutModelMainPanelPanelH__
#define __CutModelMainPanelPanelH__

#include <vector>
#include <wx/wx.h>
#include <wx/treebook.h>
#include "wx/aui/aui.h"
#include <wx/toolbar.h>

#include <iostream>
#include "marTypes.h"


#include "CutModelManager.h"
#include "CutModelException.h"
#include "CutModelView.h"

#include "vtkImageData.h"
#include "vtkRenderWindowInteractor.h"

//RaC 02-2010 Add tabs
#include <wx/aui/auibook.h>
#include <wx/panel.h>
#include <wx/checkbox.h>
#include <wx/button.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/radiobox.h>



class  creaMaracasVisu_EXPORT  CutModelMainPanel : public wxPanel
{

public:

	~CutModelMainPanel( );

	static CutModelMainPanel* getInstance(wxWindow* parent=NULL, std::string path ="");

	//static CutModelMainPanel* getInstance();

	void setImageData(vtkImageData* img);

	void setInteractor(vtkRenderWindowInteractor* interactor);

	void setRenderer(vtkRenderer* renderer);

	void initialize(std::string path);

	//RaC PolygonCutter changes
	void onCheckChanged();
	void onExecuteCutPolygon();
	void UpdatePolygon(bool isChecked);
	void UpdatePolygon();

	void onAddCutModel();

	void onUndo();

	void onRedo();

	void changeOpacity(int id,int opacity);

	void ShowViewBox(int id,bool check);

	void ChangeShape(int id,int selection);

	void changeColor(int id,double r,double g,double b);

	void updateActorDirection(int id);

	void RemoveActor(int id);

	void ExecuteCut(int id, double* range, bool isinside);

	void ExecuteAll();

	vtkImageData* GetResultImage();

	void ShowCurrentPanel(int id);

	void ShowPopUpMenu(int id);

	void ShowStatistics(int id);

	void SetType(int type);

	int GetType();


private:

	CutModelMainPanel( wxWindow* parent, std::string path);

	static CutModelMainPanel* instance;

	CutModelManager* cutmanager;	

	void checkInvariant() throw( CutModelException);

	void showErrorDialog(std::string str);

	void SaveCutModelData(std::string filename);

	void LoadCutModelData(std::string filename);

	std::vector<CutModelView*> viewpanels;

	wxAuiManager* _wxauimanager;

	int addNewViewPanel()throw( CutModelException);

	CutModelView* getModelView(int id)throw( CutModelException);

	int _panelid;

	int _type;

	//RaC 02-2010 Add tabs
	wxAuiNotebook* _notebook;

	//RaC Adds Tab to cut a prism with the polygon as the base
	void addPolygonCutterTab();

	bool _isCheck;

	bool _isFirstTime;

	wxButton *btnExecutePolygonCut;
	wxStaticText* lblMessagePolygon;
	wxRadioBox* _radioinsideout;

};


class ToolBarEventHandlerCutModel : public wxEvtHandler{

public:
	ToolBarEventHandlerCutModel();
	~ToolBarEventHandlerCutModel();

	void onAdd(wxCommandEvent& event);

	void onUndo(wxCommandEvent& event);

	void onRedo(wxCommandEvent& event);

	void onExecuteAll(wxCommandEvent& event);

private:

	DECLARE_EVENT_TABLE()
};

class PolygonCutterEventHandlerCutModel : public wxEvtHandler{
public:

	PolygonCutterEventHandlerCutModel(): wxEvtHandler(){};
	~PolygonCutterEventHandlerCutModel(){};

	void onCheckChanged(wxCommandEvent& event);
	void onExecuteCutPolygon(wxCommandEvent& event);

};


class ToolBarCutModel : public wxToolBar{


public:
	ToolBarCutModel(wxWindow * parent);
	~ToolBarCutModel(void);


private:

	ToolBarEventHandlerCutModel* _evthand;

};

#endif

