/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: CutModelView.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:20 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __CutModelViewPanelH__
#define __CutModelViewPanelH__

#include <vector>
#include <wx/wx.h>
#include <wx/radiobut.h>
#include "wx/aui/aui.h"
#include <iostream>
#include "marTypes.h"


#include "CutModelManager.h"
#include "CutModelException.h"

#include "vtkObject.h"
#include "vtkCommand.h"


class  creaMaracasVisu_EXPORT  CutModelView : public wxPanel, public vtkCommand
{

public:
	CutModelView( wxWindow* parent,double* range);
    ~CutModelView( );

	virtual void Execute(vtkObject *wdg, unsigned long eventId, void* calldata) ;
	
	int getId(){
		return _id;
	}
	void setId(int id){
		_id = id;
	}
	
	void ExecuteCut();

	void SetCurrentColor(wxColour colour);
	
private:	

	int _id;

	wxSlider* _sliderrange;
	wxRadioBox* _radioinsideout;
	//wxRadioBox* _radiocutstat;
	wxStaticText* _currentcolor;

	double* getRange();
	bool isCut();
	bool isInside();



	wxSizer* getBoxControls(wxWindow* parent, double* range);


	wxSizer* getActorProperties(wxWindow* parent);
	wxSizer* getColorChooseActor(wxWindow* parent);
	wxSizer* getOpacityActor(wxWindow* parent);

	void checkInvariant() throw( CutModelException);

};

class CutModelViewEventHandler : public wxEvtHandler{

	public:
		CutModelViewEventHandler(): wxEvtHandler(){};
		~CutModelViewEventHandler(){};

		void onColorChange(wxCommandEvent& event);			
		void onOpacityChange(wxScrollEvent& event);
		void onViewBoxChecked(wxCommandEvent& event);
		void onShapeChange(wxCommandEvent& event);
		void onStatistics(wxCommandEvent& event);
		void onExecute(wxCommandEvent& event);
		


	private:
		
};


#endif

