/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#ifndef __HISTOGRAMW1__
#define __HISTOGRAMW1__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "HistogramBase.h"
#include "marTypes.h"
#include "pPlotterWindow.h"
#include "pFunctionPoint.h"
#include "vtkImageData.h"
#include "pHistogram.h"
#include "pPlotterScaleY.h"
#include "pPlotterScaleX.h"

//#define MAX 500
#define NUM_POINTS 100
#define WINDOW_SIZE 10

class creaMaracasVisu_EXPORT Histogram:public wxPanel, HistogramBase
{
public:
	//---------------------
	// Constructor
	//----------------------

	//HistogramWidget( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag );
	
 
//EED Borrame 07Mai2009
//	Histogram( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag,vtkImageData* imageData);
	Histogram( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag);
	
	~Histogram();

	/*
	Draw the histogram in the plotter
	*/
	void drawHistogram();
	/*
		if the user resize the window	
	*/
	void OnSize( wxSizeEvent &WXUNUSED(event) );
	//---------------------------------------
	// Get Information from the widget
	//---------------------------------------
	
	/*
		get a point of the Histogram
		given the grey value
	*/
	int getHistogramPoint(int gValue);
	int getHistogramSize();
	pPlotterWindow* GetPlotterWindow(); 
	virtual void Configure(vtkImageData* imageData);
	virtual wxWindow* GetWindow();

private:
	
	 pHistogram*		histogram;
	 pPlotterWindow*	plotter;
	 int					histogramSize;
	 int					idHistogram;
	 
	 
	 DECLARE_CLASS(Histogram);
	 //----------------------------------------------------------------------------
	// wxWidget macro use declaration for handdling events
	//----------------------------------------------------------------------------
	DECLARE_EVENT_TABLE()
	
};
#endif


