
/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __HistogramDialogComboBox__
#define __HistogramDialogComboBox__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#include <wx/wx.h>
#include <vector>

#include "HistogramDialogComboBoxItem.h"
#include <fstream>
#include <wx/bmpcbox.h>
#include "vtkImageData.h"

#define COLORSFUNCTIONFILENAME "colorsfunction.txt"

class HistogramDialogComboBox : public wxPanel
{
public:
	/*
	 Constructor
	*/
	HistogramDialogComboBox(wxWindow* parent);
	//HistogramDialogComboBox(int bar_width,int bar_height);
	~HistogramDialogComboBox();

	void SetColors(std::vector<double> greyvect, std::vector<double> redvect, std::vector<double> greenvect, std::vector<double> bluevect);
	wxBitmap GetBitmap();

	std::vector<double> getGreyVector(){return _greyvect;}
	std::vector<double> getRedVector(){return _redvect;}
	std::vector<double> getGreenVector(){return _greenvect;}
	std::vector<double> getBlueVector(){return _bluevect;}

	void OnEditBitmapCombo(wxCommandEvent& event);
	void OnBitmapComboItemSelected(wxCommandEvent& event);
   	void BitmapComboItemSelect(int value);

	void OnColorLevelChanged(wxCommandEvent& event);	
	void OnWindowLevelChanged(wxCommandEvent& event);	

	void setImageData(vtkImageData* img);

	/**
	**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
	**/
	void GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value);

	/**
	**	Returns two vectors, the grey level of the point and its value, the red, green
	**	and blue value is between [0,1]
	**/
	void GetValuesColorPointsFunction(std::vector<double>& greylevel,
									std::vector<double>& red,
									std::vector<double>& green,
									std::vector<double>& blue);

	double GetWindowLevel();
	double GetColorLevel();
	void InitCurrentPathColorsFuntion();
	std::string GetFileNameOfColorsFunction();

private:

	std::vector<double> _greyvect;
	std::vector<double> _redvect;
	std::vector<double> _greenvect;
	std::vector<double> _bluevect;
	std::vector<double> _greyvecttransfer;
	std::vector<double> _value;
	vtkImageData* _img;
	double _maxgreyvalue;
	int _currentitem;	

	std::string _currentpathColorsFuntion;

	/*
	* Represents the color of the backGround. Default color is the parent color. 
	*/		

	wxBitmapComboBox*	_bitmapcombo;
	wxSlider*	_slidercolor;
	wxSlider*	_sliderwindowlevel;
	std::vector<HistogramDialogComboBoxItem*> _bitmapsitems;
	wxBitmap* colorBar_Bitmap;
	wxSizer* _bitmapsizer;

	wxSizer* getBitmapCombo();
	wxSizer* getSlidersWlCo();
	wxBitmapComboBox* getBitmapComboElements();
	void OnLoadComboBoxData(std::vector<HistogramDialogComboBoxItem*>& itembitmaps,std::string filename);
	void saveCurrentConfiguration(std::vector<HistogramDialogComboBoxItem*>& itembitmaps,std::string filename);
	void setSlidersValue();


	
};

#endif



