/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef PlaneDirectionManagerData_H_
#define PlaneDirectionManagerData_H_

#include <math.h>

#include "PlanesOperations.h"


#include <iostream>

#include <vtkArrowSource.h>
//#include <vtkConeSource.h>
#include <vtkPolyDataMapper.h>
#include <vtkActor.h>
#include <vtkProperty.h>
#include <vtkMatrix4x4.h>
#include <vtkTransform.h>


class PlaneDirectionManagerData : public PlanesOperations {

public:
	PlaneDirectionManagerData(int radio, double colour[3], int opacity);	
	~PlaneDirectionManagerData();		

	void setPoint0(double x,double y,double z){		
		p0[0] = x;
		p0[1] = y;
		p0[2] = z;
	}
	void setPoint1(double x,double y,double z){		
		p1[0] = x;
		p1[1] = y;
		p1[2] = z;
	}
	void setPoint2(double x,double y,double z){		
		p2[0] = x;
		p2[1] = y;
		p2[2] = z;
	}
	double* getPoint0(){
		return p0;		
	}
	double* getPoint1(){
		return p1;		
	}
	double* getPoint2(){
		return p2;		
	}

	void UpdateActor();

	vtkProp3D* GetActor();

	double* GetDirection(){
		return _dir;
	}

	void ChangeColour(double r,double g,double b);
	
private:
	double* p0;
	double* p1;
	double* p2;
	int _radio;
	double* _colour;
	int _opacity;
	double* _dir;
	
	vtkArrowSource *_vtkarrow;	
	vtkPolyDataMapper *_arrowMapper;
	vtkActor *_arrowActor;

	double* GetMidPoint();
	
};

#endif /*PlaneDirectionManagerData_H_*/
