/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _PlaneDirectionViewer_H_
#define _PlaneDirectionViewer_H_

#include <math.h>

#include <iostream>
#include <vector>

#include <vtkRenderer.h>

#include <wx/wx.h>
#include "PlaneDirectionViewerPanel.h"
#include "PlaneDirectionManager.h"
#include "marTypes.h"

class  creaMaracasVisu_EXPORT PlaneDirectionViewer : public wxPanel  {

public:
	PlaneDirectionViewer(wxWindow* parent, int radio, double colour[3], int opacity);	
	~PlaneDirectionViewer();	

	void SetRenderer(vtkRenderer* render);
	void SetVectors( std::vector<double> lstPointsx, std::vector<double> lstPointsy, std::vector<double> lstPointsz);

	void UpdateDirections() throw (std::exception);

	static PlaneDirectionViewer* getInstance(wxWindow* parent,int radio, double colour[3], int opacity);

	static PlaneDirectionViewer* getInstance();
	
	void addRemoveActor(int index, bool addremove);

	void changeColor(int index,double r,double g,double b);

	void WriteInformation(std::string filename,double* spc=NULL);

	void SetArrowSize(int arrowsize);
private:
	static PlaneDirectionViewer* instance;
	PlaneDirectionManager* manager;
	std::vector<PlaneDirectionViewerPanel*> viewdata;
};

#endif /*PlanesOperations_H_*/
