/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __Propagation_h_INCLUDED__
#define __Propagation_h_INCLUDED__

#include "vtkImageData.h"

/* EED 03/07/2008
  #include "itkMatrix.h"
*/

#include "marTypes.h"
#include "manualContourModel.h"
#include "time.h"
#include <wx/wx.h>

class Vector
{
	public:
			Vector	();
			~Vector	();
            void	set_vec		( double val );
			void	set_var		( double val );
			double	get_vec		( int id );
			double	get_var		( );
			int		getsize_vec	( );
			void	copyVector	( std::vector<Vector>*vec1, std::vector<Vector>*vec2 );	
			void	printVector	( std::vector<Vector>*vec1 );
			void	set_x		( double val );
			void	set_y		( double val );
			void	set_z		( double val );
			void    set_plane	( int val );
			double	get_x		( int id );
			int		getsize_x	( );
			double	get_y		( int id );
			int		getsize_y	( );
			double	get_z		( int id );
			int		getsize_z	( );
			int		get_plane	( );
			void	resetVec	( );
			std::vector<double>	getVec();

	private:
			double _var;
			int _plane;
			std::vector<double> _vec;
			std::vector<double> _vecX;
			std::vector<double> _vecY;
			std::vector<double> _vecZ;
};

class creaMaracasVisu_EXPORT PropContour
{
	public:
			PropContour();
			~PropContour();

/* EED 03/07/2008
			vtkImageData*	method_RBF					( double rad, std::vector<double>*CoordX, std::vector<double>*CoordY, 
														  std::vector<double>*CoordZ );
			vtkImageData*	method_RBF_3D				( double rad, std::vector<double>*CoordX, std::vector<double>*CoordY, 
														  std::vector<double>*CoordZ );
			vtkImageData*	method_RBF_3D_ThinPlate		( double rad, std::vector<double>*CoordX, std::vector<double>*CoordY, 
														  std::vector<double>*CoordZ );
*/

			int				VectorDirection				( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void			VectorOrder					( int dir, int posinic, std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ);
			void			ReadKeyContour				( FILE* fd );
			void			ResetKeyContours			( );
			void			SetKeyContours				( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			vtkImageData*	CalculeSplinePropagation	(  );  
			void			GetKeyContours				( std::vector<double>*KeyX, std::vector<double>*KeyY, std::vector<double>*KeyZ, std::vector<int>*KeyS );
			void			GetPropagatedContours		( std::vector<Vector>*planevec );
			void			GetIdContour				( int id, std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ );
			void			SetInterpNumber				( int val );
			int				FindIdWithZ					( double z );

	private:

/* EED 03/07/2008
			double			RBF_WendLand				( double norm, double m_rad );
			double			RBF_ThinPlate				( double norm );
			double			RBF_ThinPlate_3D			( double norm );
*/

			void			PreparePointsForSpline		( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ, std::vector<int>*Sizes );
			vtkImageData*	method_Spline				( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ, std::vector<int>*Sizes );
			void			ResetPlaneVector();
			
			int						_interpnumber;

			int						_dimImage[3];
			vtkImageData			*imagedataValue;
			manualContourModel		*_mContourModel;

			std::vector<double>		_KeyContourX;
			std::vector<double>		_KeyContourY;
			std::vector<double>		_KeyContourZ;
			std::vector<int>		_KeyContourSizes;

			std::vector<Vector>		_planevector;
};
#endif // __Propagation_h_INCLUDED__
 
 
