/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: UtilVtk3DGeometriSelection.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __UTILVTK3DGEOMETRISELECTION__
#define __UTILVTK3DGEOMETRISELECTION__

#include <vtkMarchingCubes.h>

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class UtilVtk3DGeometriSelection
{
public:
	UtilVtk3DGeometriSelection();
	~UtilVtk3DGeometriSelection();
	void	SetDimentions(int w,int h,int d);
	void	SetMarchingCube(vtkMarchingCubes *mCubes);
	bool	FindCubePointsFromPoints( double* pO, double* pF, double* pickPoint, double* cameraPos );
	bool	GetPointAndNormalIntersection( double* p, double* n, double* pO, double* pF );
	bool	IntersectPlaneWithLine( double* p, double* x1, double* x2, double* x3, double* x4, double* x5 );

	double	DistanceMinPointToLine(double *p,double *pA, double *pB);
	void	IntersectionPlaneAndLine(double *pResult,double *n,double *p,double *pA,double *pB);

protected:
private:
	int					_width;
	int					_height;
	int					_depth;
	vtkMarchingCubes	*_mCubes;
};



#endif //__UTILVTK3DGEOMETRISELECTION__
