/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file button.h
 * @brief Contains the Button class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTON_H
#define BUTTON_H

//#include <wx/listctrl.h>
#include <wx/bmpbuttn.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/bitmap.h>

#include "system.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class Button button.h "button.h"
		 *	@brief This class contains the Button in the view perspective.
		 *  @details This class contains the information of a button, it derives from wxBitmapButton.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxbitmapbutton.html">wxBitmapButton</a>
		 */
		class Button : public wxBitmapButton
		{
			public:
				//typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::TFunctor TFunctor;
				 *	@brief Defines the TFunctor type.
				 */
				typedef creaButtonContainer::model::TFunctor TFunctor;
				// ----------------------------------------------------------------------------------
				//end of typedef definition
			public:
				
				// ----------------------------------------------------------------------------------
				/*! @fn Button::Button( wxWindow* parent, long id, ButtonPair* pair );
				 *	@brief This is the constructor.
				 * 	@param parent The wxWindow* parent.
				 * 	@param id The wxID of the button.
				 * 	@param pair The button information.
				 */
				Button( wxWindow* parent, long id, ButtonPair* pair );
				// ----------------------------------------------------------------------------------
				/*! @fn virtual Button::~Button( );
				 *	@brief This is the destructor.
				 */
				virtual
				~Button( );
				// ----------------------------------------------------------------------------------
				/*! @fn long Button::GetID( );
				 * 	@brief This method gets the wxID of the button.
				 * 	@return long wxID of the button.
				 */
				long
				GetID( );
				// ----------------------------------------------------------------------------------
				/*! @fn std::string Button::GetButtonName( );
				 * 	@brief This method returns the name of the button.
				 * 	@return std::string The name of the button.
				 */
				StringType
				GetButtonName( );
				
				// ----------------------------------------------------------------------------------
				/*! @fn std::string Button::GetIconPath( );
				 * 	@brief This method returns the iconPath of the button.
				 * 	@return std::string The path of the icon.
				 */
				BitmapType
				GetIcon( );

				// ----------------------------------------------------------------------------------
				/*! @fn std::string Button::GetIconPath( );
				 * 	@brief This method returns the iconPath of the button.
				 * 	@return std::string The path of the icon.
				 */
				//StringType
				//GetIconPath( );
				// ----------------------------------------------------------------------------------
				/*! @fn std::string Button::GetDescription( );
				 * 	@brief This method returns a the description of the button.
				 * 	@return std::string The tooltip of the button.
				 */
				StringType
				GetDescription( );
				// ----------------------------------------------------------------------------------
				/*! @fn void Button::Execute( );
				 * 	@brief This method executes the Functor (Call_Back Function).
				 * 	This is the event of the button that it was defined to be called remotely using
				 * 	call_back functions. In this project it was implemented using Functors.
				 * 	@exception std::bad_alloc
				 * 	@see TFunctor
				 */
				void
				Execute( );
				// ----------------------------------------------------------------------------------
			private:
				ButtonPair* m_ButtonPair; //! <The pair with the button information.
				
		};
	}//ecapseman
}//ecapseman

#endif // BUTTON_H
