/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file buttonContainerController.h
 * @brief This contains the ButtonContainerController class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTONCONTAINERPANEL_H
#define BUTTONCONTAINERPANEL_H

#include <wx/scrolwin.h>
#include <wx/button.h>
#include <wx/sizer.h>

#include <list>
#include <map>
#include <exception>

#include "buttonGroup.h"
#include "groupManager.h"
#include "buttonGroupFactory.h"
#include "containerSettings.h"
#include "buttonContainerController.h"
//EED-MLER #include "listGroup.h"
//EED-MLER #include "listGroupFactory.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*!	@namespace<creaButtonContainer::controller>
	 *	@brief Contains the implementation of the controller in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace controller
	{
		/*! @class ButtonContainerController buttonContainerController.h "buttonContainerController.h"
		 *	@brief This class contains the ButtonContainerPanel controller.
		 *  @details This class describes the button events, it derives from wxEvtHandler.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxevthandler.html">wxEvtHandler</a>
		 */
		class ButtonContainerController;
	}

	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class ButtonContainerPanel buttonContainerPanel.h "buttonContainerPanel.h"
		 *  @brief This class is the container of the creaButtonContainer.
		 *  @details This class derives from wxScrolledWindow and manages the view of the buttonContainer.
		 *  @bug The scrolled it doesn't work! (to be changed soon)
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxscrolledwindow.html">wxScrolledWindow</a>
		 */
		class ButtonContainerPanel : public wxScrolledWindow
		{
			public:
				//typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				 *	@brief Defines the ButtonGroup type.
				 */
				typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::GroupManager GroupManager;
				 *	@brief Defines the GroupManager type.
				 */
				typedef creaButtonContainer::view::GroupManager GroupManager;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::list< ButtonGroup* > ButtonGroupList;
				 *	@brief Defines the ButtonGroupList type.
				 */
				typedef std::list< ButtonGroup* > ButtonGroupList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::map< long, GroupManager* > GroupManagerList;
				 *	@brief Defines the GroupManagerList type.
				 */
				typedef std::map< long, GroupManager* > GroupManagerList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef wxFlexGridSizer Sizer;
				 *	@brief Defines the Sizer type.
				 */
				typedef wxFlexGridSizer Sizer;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::list< long > KeyList;
				 *	@brief Defines the KeyList type.
				 */
				typedef std::list< long > KeyList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::ContainerSettings ButtonGroupSettings;
				 *	@brief Defines the ButtonGroupSettings type.
				 */
				typedef creaButtonContainer::model::ContainerSettings
				    ButtonGroupSettings;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::ButtonGroupFactory ButtonGroupFactory;
				 *	@brief Defines the ButtonGroupFactory type.
				 */
				typedef creaButtonContainer::model::ButtonGroupFactory
				    ButtonGroupFactory;
				// ----------------------------------------------------------------------------------
				/*!	creaButtonContainer::controller::ButtonContainerController BCController;
				 *	@brief Defines the BCController type.
				 */
				typedef creaButtonContainer::controller::ButtonContainerController
				    BCController;


				//typedef creaButtonContainer::model::ListGroupFactory ListGroupFactory;

				//typedef creaButtonContainer::view::ListGroup ListGroup;

				//typedef std::list< ListGroup* > ListGroupList;

				//typedef creaButtonContainer::model::ListGroupFactory ListGroupFactory;


				// ----------------------------------------------------------------------------------
				//end of typedef definition
			public:
				/*! @fn ButtonContainerPanel( wxWindow* parent, ButtonGroupSettings* settings );
				 * @brief This is the parameterized constructor.
				 * @param parent wxWindow pointer to parent.
				 * @param settings ButtonGroupSettings Pointer to button container settings.
				 */
				ButtonContainerPanel( wxWindow* parent, ButtonGroupSettings* settings, int type );
				// ----------------------------------------------------------------------------------
				/*! @fn ~ButtonContainerPanel( );
				 * @brief This is the destructor.
				 */
				virtual
				~ButtonContainerPanel( );
				// ----------------------------------------------------------------------------------
				/*! @fn SetGroupContainer( ButtonGroupList groupContainer );
				 * @brief This method sets the settings to the container.
				 * @param groupContainer
				 */
				void
				SetButtonGroupContainer( ButtonGroupList groupContainer );
				// ----------------------------------------------------------------------------------
				/*! @fn PanelInit( );
				 *	This method initializes the panel.
				 *	@exception std::bad_alloc
				 */
				void
				PanelInit( int type);
				// ----------------------------------------------------------------------------------

				//void
				//SetListGroupContainer(ListGroupList groupContainer );
				// ----------------------------------------------------------------------------------
				/*! @fn FitSizer( );
				 * This method fits and organizes the sizer.
				 */
				void
				FitSizer( );
				// ----------------------------------------------------------------------------------
			public:
				friend class creaButtonContainer::controller::ButtonContainerController;
			private:
				GroupManagerList 	m_GroupManagerList; //!<The container of managers.
				ButtonGroupList 	m_ButtonGroupList; //!<The list of button groups.
				BCController* 		m_ButtonCController; //!<Pontier to controller.
				Sizer* 				m_Sizer; //!<Pointer to wxSizer


				//ListGroupList m_ListGroupList;

			DECLARE_EVENT_TABLE() //!<Event Table declaration.
		};
	}//ecapseman
}//ecapseman

#endif // BUTTONCONTAINERPANEL_H
