/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file buttonManager.h
 * @brief This contains the ButtonManager class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef CARTOBUTTONCONTAINER_H
#define CARTOBUTTONCONTAINER_H

#include <wx/sizer.h>
#include <wx/bmpbuttn.h>
#include <wx/stattext.h>
#include <wx/string.h>

#include <map>
#include <exception>

#include "button.h"
#include "buttonGroup.h"
#include "listWx.h"
#include "listGroup.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class ButtonManager buttonManager.h "buttonManager.h"
		 *	@brief This class contains the ButtonManager view.
		 *  @details This class describes a wxFlexGridSizer with the button manager.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxflexGridSizer.html">wxFlexGridSizer</a>
		 */
		class ButtonManager : public wxFlexGridSizer
		{
			public:
				//typedef definition.
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::Button Button;
				 *	@brief Defines the Button type.
				 */
				typedef creaButtonContainer::view::Button Button;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				 *	@brief Defines the ButtonGroup type.
				 */
				typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::map< long, Button* > ButtonContainer;
				 *	@brief Defines the ButtonContainer type.
				 */
				typedef std::map< long, Button* > ButtonContainer;
				// ----------------------------------------------------------------------------------
				//MLER
				//typedef creaButtonContainer::view::ListGroup ListGroup;
				//typedef std::map<long, ListWx* > ListContainer;

				//end of typedef definition.
			public:
				// ----------------------------------------------------------------------------------
				/*! @fn ButtonManager( );
				 * @brief This is the default constructor.
				 * @exception std::bad_alloc
				 */
				ButtonManager( );
				// ----------------------------------------------------------------------------------
				/*! @fn ButtonManager( ButtonGroup* buttonGroup );
				 * @brief This is the parameterized constructor
				 * @param buttonGroup The group of buttons.
				 */
				ButtonManager( ButtonGroup* buttonGroup );
				// ----------------------------------------------------------------------------------
				//MLER
				//ButtonManager (ListGroup* buttonGroup);
				// ----------------------------------------------------------------------------------

				/*! @fn ~ButtonManager( );
				 * @brief This is the destructor.
				 */
				virtual
				~ButtonManager( );
				// ----------------------------------------------------------------------------------
				/*! @fn SetGroupName( wxStaticText* groupName );
				 * @details Sets the groupName.
				 * @param groupName
				 */
				void
				SetGroupName( wxStaticText* groupName );
				// ----------------------------------------------------------------------------------
				/*! @fn ShowButtonManager( );
				 * @brief This method shows the ButtonManager
				 */

				void
				ShowButtonManager( );
				// ----------------------------------------------------------------------------------
				/*! @fn HideButtonManager( );
				 * @brief This method hides the ButtonManager.
				 * @exception std::bad_alloc
				 */
				void
				HideButtonManager( );
				// ----------------------------------------------------------------------------------
			private:
				// ----------------------------------------------------------------------------------
				/*! @fn SetButtonManager( ButtonContainer buttonContainer );
				 * @brief This method set the buttons and it is private.
				 * @param buttonContainer
				 */
				void
				SetButtonManager( ButtonContainer buttonContainer );
				// ----------------------------------------------------------------------------------
				//MLER
				/*void
				SetListManager( ListContainer buttonContainer );*/
				// ----------------------------------------------------------------------------------


			private:
				wxStaticText* m_GroupName; //!<The name of the group.
				wxGridSizer* m_GridSizer; //!<The sizer that contains the buttons.
		};
	}//ecapseman
}//ecapseman

#endif // CARTOBUTTONCONTAINER_H
