/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file containerSettings.h
 * @brief Contains the ContainerSettings class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTONGROUPSETTINGS_H_
#define BUTTONGROUPSETTINGS_H_

#include <vector>
#include <wx/bitmap.h>
//EED-MLER  #include <wx/listctrl.h>

#include "structBCSettings.h"
#include "system.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */


namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::model>
	 *	@brief Contains the implementation of the model in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace model
	{
		/*! @class ContainerSettings containerSettings.h "containerSettings.h"
		 *	@brief This class contains the settings of the button container.
		 */
		class ContainerSettings
		{
			public:
				//typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::BCSettingsStruct BCSettingsStruct;
				 *	@brief Defines the BCSettingsStruct type.
				 */
				typedef creaButtonContainer::model::BCSettingsStruct BCSettingsStruct;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::vector< BCPSettingsStruct* > BCStructVectorType;
				 *	@brief Defines the BCStructVectorType type.
				 */
				typedef std::vector< BCSettingsStruct* > BCStructVectorType;
				// ----------------------------------------------------------------------------------
				//end of typedef definition
			public:
				// ----------------------------------------------------------------------------------
				/*! @fn ContainerSettings::ContainerSettings( )
				 *	@brief This is the constructor.
				 */
				ContainerSettings( );
				// ----------------------------------------------------------------------------------
				/*! @fn virtual ContainerSettings::~ContainerSettings( )
				 *	@brief This is the destructor.
				 */
				virtual
				~ContainerSettings( );
				
				// ----------------------------------------------------------------------------------
				/*! @fn ButtonGroupMap ContainerSettings::GetButtonGroupContainer( )
				 * 	@brief This method returns a container of buttons ordered by group.
				 * 	@return ButtonGroupMap A container with buttons
				 */
				ButtonGroupMap
				GetButtonGroupContainer( );
				// ----------------------------------------------------------------------------------
				/*! @fn KeyMapList ContainerSettings::GetGroupNameList( )
				 * 	@brief This method returns a container with the name of the groups.
				 * 	@return KeyMapList A list with the name of the button groups.
				 */
				KeyMapList
				GetGroupNameList( );
				
				// ----------------------------------------------------------------------------------
				/*! void ContainerSettings::SetButtonGroupContainer( ButtonGroupMap m_ButtonGroupContainer )
				 * 	@brief This method allows to create the ButtonGroupContainer.
				 * 	@param bgContainer The ButtonGroupMap with all buttons.
				 */
				void
				SetButtonGroupContainer( ButtonGroupMap bgContainer );


				// ----------------------------------------------------------------------------------
				/*! void ContainerSettings::SetGroupNameList( KeyMapList gNameList )
				 * @brief This method sets a container with the name of the groups.
				 * @param gNameList the KeyMapList with all groupNames.
				 */
				void
				SetGroupNameList( KeyMapList gNameList );
				

				// ----------------------------------------------------------------------------------
				/*!
				 * @fn ContainerSettings::AddButton( const std::string & groupName, const std::string buttonName,
				 const std::string iconpath, const std::string buttonDescription,
				 FunctionEventType event )
				 * @brief This method adds a new button to the container.
				 * @param groupName The name of the group of buttons.
				 * @param buttonName The ID of the button.
				 * @param iconpath The path of the button icon.
				 * @param buttonDescription The description of the button.
				 * @param event The event associated to the button.
				 * @see class Functor, ConcreteFunctor for add an event for a button.
				 * @exception std::bad_alloc
				 */
				void
				AddButton( const StringType & groupName, const StringType &buttonName,
				    const wxBitmap &icon, const StringType &buttonDescription,
				    FunctionEventType event );
				// ----------------------------------------------------------------------------------
				/*! @fn void AddButton( BCSettingsStruct* info );
				 * 	@brief This method adds a new button to the container using the
				 * 	BCSettingsStruct structure.
				 * 	@exception std::bad_alloc
				 * 	@param info
				 */
				void
				AddButton( BCSettingsStruct* info );
				// ----------------------------------------------------------------------------------
				/*! @fn void AddButtons( BCStructVectorType infoList );
				 *	@brief This method adds new buttons to the container.
				 *	@exception std::bad_alloc
				 * 	@param infoList
				 */
				void
				AddButtons( BCStructVectorType infoList );

				// ----------------------------------------------------------------------------------
//				AddItems( BCStructVectorType infoList );

				// ----------------------------------------------------------------------------------
				// ----------------------------------------------------------------------------------
			private:
				ButtonGroupMap m_ButtonGroupContainer; //! <The container with the group of buttons.
				KeyMapList m_GroupNameList; //! <The container with the name of the groups of buttons.

				//ListGroupMap m_ListGroupContainer; // contenedor del grupo de listas
		};
	}
}

#endif /* BUTTONGROUPSETTINGS_H_ */
