/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file PanelButtonContainer
 * @brief This contains the ButtonContainerSettings class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef PANELBUTTONCONTAINER_H_
#define PANELBUTTONCONTAINER_H_

#include <wx/panel.h>
#include <wx/aui/aui.h>
#include <string>
#include <wx/gdicmn.h>

#include "containerSettings.h"
#include "buttonContainerPanel.h"
#include "buttonContainerSettings.h"
#include "functor.h"
#include "listWx.h"

/*!	@namespace <creaPanelButtonContainer>
 *	@brief Contains the creaPanelButtonContainer library included in creaMaracasVisu.
 */
namespace creaPanelButtonContainer
{
	/*! @class PanelButtonContainer panelButtonContainer.h "panelButtonContainer.h"
	 *	@brief This class contains the PanelButtonContainer. It derives from wxPanel.
	 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxpanel.html">wxPanel</a>
	 */
	class PanelButtonContainer : public wxPanel
	{
		public:
			//typedef definition.
			// ----------------------------------------------------------------------------------
			/*!	typedef creaPanelButtonContainer::ButtonContainerSettings ButtonContainerSettings;
			 *	@brief Defines the ButtonContainerSettings type.
			 */
			typedef creaPanelButtonContainer::ButtonContainerSettings
			    ButtonContainerSettings;
			/*!	typedef creaButtonContainer::view::ButtonContainerPanel ButtonContainerPanel;
			 *	@brief Defines the ButtonContainerPanel type.
			 */
			typedef creaButtonContainer::view::ButtonContainerPanel
			    ButtonContainerPanel;
			typedef creaButtonContainer::view::ListWx ListWx;
			// ----------------------------------------------------------------------------------
			//end of typedef definition.
		public:
			// ----------------------------------------------------------------------------------
			/*! @fn PanelButtonContainer( wxWindow* parent, ButtonContainerSettings* bcSettings );
			 *	@brief This is the parameterized constructor.
			 * 	@param parent The wxWindow pointer to parent
			 * 	@param bcSettings //The buttonContainerSettings
			 */
			PanelButtonContainer( wxWindow* parent,
			    ButtonContainerSettings* bcSettings, int type );
			// ----------------------------------------------------------------------------------
			/*! @fn virtual PanelButtonContainer( );
			 *	@brief This is the destructor.
			 */
			virtual
			~PanelButtonContainer( );
			// ----------------------------------------------------------------------------------
			/*! @fn void UpdatePanel( const std::string &buttonName );
			 *  @brief This method Updates the m_ButtonPanel to a panel
			 *  of the clicked button in creaButtonContainer.
			 * 	@param buttonName
			 */
			void
			UpdatePanel( const std::string &buttonName );
			// ----------------------------------------------------------------------------------
			/*! @fn void GenericButtonEvent( const std::string &buttonName );
			 *	@brief This method is the function that calls the panels contained in the buttons
			 *	(in creaButtonContainer is the function contained in the functors to be called back.
			 * 	@param buttonName The name of the button
			 */
			void
			GenericButtonEvent( const std::string &buttonName );

			// ----------------------------------------------------------------------------------
			void
			UpdateListPanel( const std::string &buttonName );

			void
			GenericListEvent( const std::string &buttonName );
			//MLER

			// ----------------------------------------------------------------------------------
		private:
			//Settings
			ButtonContainerSettings* m_ButtonContainerSettings; //!<This is the buttonContainer settings.
			//Panel
			ButtonContainerPanel* m_ButtonContainerPanel; //!<This is the panel with de buttons (creaButtonContainer)
			wxAuiManager* m_AuiManager; //!<The AUI Manager for the panels.
			wxPanel* m_ButtonPanel; //!<This is the panel used to contain the panels of the buttons. (it changes with the buttonAction)
			wxPanel* m_ListPanel;

			ListWx* mylist; //MLER

		DECLARE_EVENT_TABLE() //!<Event Table declaration.
	};
}//ecapseman

#endif // PANELBUTTONCONTAINER_H_
