/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file functor.h
 * @brief Defines TFunctor class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef TFUNCTOR_H_
#define TFUNCTOR_H_

#include <string>
#include <exception>

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::model>
	 *	@brief Contains the implementation of the model in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace model
	{
		//typedef definition.
		/*!	@typedef std::string ButtonIDType;
		 *	@brief Defines the ButtonIDType type.
		 */
		typedef std::string ButtonIDType;
		//end of typedef definition
		/*! @class TFunctor functor.h "functor.h"
		 *	@brief This is an abstract class for call_back functions.
		 */
		class TFunctor
		{
			public:
				// two possible functions to call member function. virtual cause derived
				// classes will use a pointer to an object and a pointer to a member function
				/*! @fn virtual void TFunctor::operator()( const ButtonIDType &buttonName )
				 *	@brief	To make the function call.
				 *	Call_Back function.
				 * 	@param buttonName
				 */
				virtual void
				operator()( const ButtonIDType &buttonName )=0; // call using operator
				/*! @fn
				 *  @brief Call using function.
				 *  Call_Back function.
				 * 	@param buttonName
				 */
				virtual void
				Call( const ButtonIDType &buttonName )=0;
		};

		// derived template class
		/*! @tparam <typename TClass>
		 *	@brief TClass makes TConcreteFunctor usable for all Classes.
		 */
		template< typename TClass >
			/*! @class TConcreteFunctor: public TFunctor  functor.h "functor.h"
			 *	@brief This class allows to make call_back functions.
			 */
			class TConcreteFunctor : public TFunctor
			{
				public:
					/*! @fn TConcreteFunctor::TConcreteFunctor( TClass* _pt2Object, void
					 (TClass::*_fpt)( const ButtonIDType &buttonName ) );
					 *	@brief This is the parameterized constructor.
					 *	Takes pointer to an object and pointer to a member and stores them in two private variables
					 * 	@param _pt2Object Pointer to object.
					 * 	@param _fpt Pointer to the function.
					 * 	@param buttonName The ID of the button (ButtonName).
					 */
					TConcreteFunctor( TClass* _pt2Object, void
					(TClass::*_fpt)( const ButtonIDType &buttonName ) );
					// -------------------------------------------------------------------------------
					/*! @fn virtual void TConcreteFunctor::operator()( const ButtonIDType &buttonName );
					 * 	@brief Override operator "()". Execute member function.
					 *	@see TFunctor
					 * 	@param buttonName
					 * 	@exception std::bad_alloc
					 */
					virtual void
					operator()( const ButtonIDType &buttonName );
					// -------------------------------------------------------------------------------
					/*! @fn virtual void TConcreteFunctor::Call( const ButtonIDType &buttonName );
					 *	@brief Override function "Call". Execute member function
					 *	@see TFunctor
					 *	@param buttonName
					 *	@exception std::bad_alloc
					 */
					virtual void
					Call( const ButtonIDType &buttonName );
					// -------------------------------------------------------------------------------
				private:
					void
					(TClass::*fpt)( const ButtonIDType &buttonName ); //! <void (TClass::*fpt) Pointer to member function.
					TClass* pt2Object; //! <TClass* pointer to object.
			};

	}//ecapseman
}//ecapseman

//! @include "functor.txx"
#include "functor.txx"

#endif /* TFUNCTOR_H_ */
