/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file functor.cxx
 * @brief Implements TFunctor class and it propose is Call_Back Functions
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
*/

namespace creaButtonContainer
{
  namespace model
  {
	  // constructor - takes pointer to an object and pointer to a member and stores
	  // them in two private variables
	  // -------------------------------------------------------------------------------
	  template< typename TClass >
	  TConcreteFunctor< TClass >::TConcreteFunctor( TClass* _pt2Object, void
	  (TClass::*_fpt)( const ButtonIDType &buttonName ) )
	  {
		  this->pt2Object = _pt2Object;
		  this->fpt = _fpt;
	  }
	  // -------------------------------------------------------------------------------
	  // override operator "()" // execute member functions
	  template< typename TClass >
	  void
	  TConcreteFunctor< TClass >::operator()( const ButtonIDType &buttonName )
	  {std::cout << "MLER - TConcreteFunctor< TClass >::operator():" << buttonName << std::endl;
	    try
	    {
		  ( *pt2Object.*fpt )( buttonName );
	    }//yrt
	    catch ( const std::exception& e )
	    {
		  std::cerr<< "TConcreteFunctor< TClass >::operator()( const ButtonIDType &buttonName )"
				  <<" exception: " << e.what( ) << std::endl;
	    }//hctac
	  }
	  // -------------------------------------------------------------------------------
	  // override function "Call" // execute member function
	  template< typename TClass >
	  void
	  TConcreteFunctor< TClass >::Call( const ButtonIDType &buttonName )
	  {
	  	std::cout << "MLER - TConcreteFunctor< TClass >::Call " << buttonName << std::endl;
	    try
	    {
		  ( *pt2Object.*fpt )( buttonName );
	    }//yrt
	    catch ( const std::exception& e )
	    {
		  std::cerr<< "TConcreteFunctor< TClass >::Call( const ButtonIDType &buttonName )"
				  <<" exception: " << e.what( ) << std::endl;
	    }//hctac
	  }
  }//ecapseman
}//ecapseman

