/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file groupManager.h
 * @brief This contains the GroupManager class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef GROUPMANAGER_H
#define GROUPMANAGER_H

#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>

#include <list>
#include <iostream>
#include <exception>

#include "buttonManager.h"
#include "buttonGroup.h"
#include "listGroup.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class GroupManager groupManager.h "groupManager.h"
		 *	@brief This class contains the GroupManager.
		 *  @details This class describes a wxFlexGridSizer with the group manager.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxflexGridSizer.html">wxFlexGridSizer</a>
		 */
		class GroupManager : public wxFlexGridSizer
		{
			public:
				//typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				 *	@brief Defines the ButtonGroup type.
				 */
				typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				// ----------------------------------------------------------------------------------
				/*!	@typedef wxButton ExpansionButton;
				 *	@brief Defines the ExpansionButton type.
				 */
				typedef wxButton ExpansionButton;
				// ----------------------------------------------------------------------------------
				//MLER
				//typedef creaButtonContainer::view::ListGroup ListGroup;

				//end of typedef definition.
			public:
				// ----------------------------------------------------------------------------------
				/*! @fn GroupManager( wxWindow* parent, ButtonGroup* buttonGroup );
				 *	@brief This is the parameterized constructor.
				 * 	@param parent The wxWindow* parent
				 * 	@param buttonGroup The pointer to the ButtonGroup.
				 */
				GroupManager( wxWindow* parent, ButtonGroup* buttonGroup );
				// ----------------------------------------------------------------------------------

				//MLER
				//GroupManager( wxWindow* parent, ListGroup* listGroup );
				/*! @fn ~GroupManager( );
				 *  @brief This is the destructor.
				*/
				virtual
				~GroupManager( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButtonID( );
				 *  @brief This method returns the Button ID.
				 *  @return
				 */
				long
				GetButtonID( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButton( );
				 * 	@brief This method returns the expansion button.
				 * @return
				 */
				ExpansionButton*
				GetButton( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButtonManager( );
				 *	@brief This method returns the manager of the buttons.
				 * 	@return
				 */
				ButtonManager*
				GetButtonManager( );
				// ----------------------------------------------------------------------------------
				/*! @fn SetButtonID( long id );
				 *	@brief This method sets the ID of the expansion button.
				 * @param id
				 */
				void
				SetButtonID( long id );
				// ----------------------------------------------------------------------------------
				/*! @fn SetButton( ExpansionButton* button );
				 *	@brief This method sets the expansion button.
				 * @param button
				 */
				void
				SetButton( ExpansionButton* button );
				// ----------------------------------------------------------------------------------
				/*! @fn SetButtonManager( ButtonManager* manager );
				 *	@brief This method Sets the ButtonManager
				 * @param manager A pointer with the manager.
				 */
				void
				SetButtonManager( ButtonManager* manager );
				// ----------------------------------------------------------------------------------
				/*! @fn HideSubPanel( bool hide );
				 *	@brief This method hides the subPanel (Hides the buttons).
				 * @param hide True if you need to hide the buttons.
				 */
				void
				HideSubPanel( bool hide );

			private:
				long m_IDExpButton; //!<ID of "+""-" expansion button.
				ExpansionButton* m_ExpansionButton; //!<The expansion button.
				ButtonManager* m_ButtonManager; //!<The button manager.



		};
	}//ecapseman
}//ecapseman

#endif // GROUPMANAGER_H
