/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	image3DDequeUR.h
 * @brief	This file contains the Image3DDequeUR class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef IMAGE3DDEQUEUR_H_
#define IMAGE3DDEQUEUR_H_

#include "imageDequeUR.h"
#include <ctime>

/*! @class Image3DDequeUR image3DDequeUR.h "image3DDequeUR.cxx"
 *	@brief This class contains the management of the undo/redo deque - Concrete Class
 *  @details This class derives from ImageDequeUR.
 */
class Image3DDequeUR: public ImageDequeUR {
public:
	//typedef definition
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::deque<ImageInfoUR*> ImageInfoDeque;
	 *	@brief Defines the deque of ImageInfoUR for the undo/redo.
	 */
	typedef std::deque<ImageInfoUR*> ImageInfoDeque;
	// ----------------------------------------------------------------------------------
public:
	// ----------------------------------------------------------------------------------
	/*! @fn Image3DDequeUR();
	 * @brief This is the default constructor.
	 */
	Image3DDequeUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ~Image3DDequeUR();
	 * @brief This is the destructor.
	 */
	virtual ~Image3DDequeUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void AddImagesToURContainer(VTKImageDataPointerType imgUndo,
	 VTKImageDataPointerType imgRedo, ImageMManager* imMManager);
	 * @brief This method adds the images for undo and redo in a container
	 * @param imgUndo The undoImage cropped.
	 * @param imgRedo The redoImage cropped.
	 * @param imManager The image manager.
	 */
	virtual void AddImagesToURContainer(VTKImageDataPointerType imgUndo,
			VTKImageDataPointerType imgRedo, ImageMManager* imMManager);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void CleanURContainerFromIndex(const int& index);
	 * @brief This method allows to clean the container from a given index.
	 * @param index The index.
	 */
	virtual void CleanURContainerFromIndex(const int& index);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void ManageMemory();
	 * @brief This method cleans the memory.
	 * @details This method cleans the principal memory when the images are not in use.
	 */
	virtual void ManageMemory();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ImageInfoUR* Undo();
	 * @brief This method is the undo action.
	 * @return
	 */
	virtual ImageInfoUR* Undo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ImageInfoUR* Redo();
	 * @brief This method is the redo action.
	 * @return
	 */
	virtual ImageInfoUR* Redo();
	// ----------------------------------------------------------------------------------
	/*! @fn void SetGlobalPath(const StringType& globalPath);
	 * @brief This method sets the global path where the temporary files will be stored.
	 * @param globalPath The String with the path.
	 */
	void SetGlobalPath(const StringType& globalPath);
	// ----------------------------------------------------------------------------------
	/*! @fn StringType GetGlobalPath();
	 * @brief This method returns a String with the global path.
	 * @return
	 */
	StringType GetGlobalPath();
	// ----------------------------------------------------------------------------------
	/*! @fn StringType GetImageName(const int & pos);
	 * @brief This method returns a String with an image name which won't be repeated.
	 * @param pos The position of the container to manage a sequence.
	 * @return
	 */
	StringType GetImageName(const int & pos);
	// ----------------------------------------------------------------------------------
	/*! @fn void CleanHardDisk();
	 * @brief This method cleans the hard disk of the temporary files.
	 */
	void CleanHardDisk();
	// ----------------------------------------------------------------------------------
protected:
	ImageInfoDeque m_ImgURDeque; //!<This is the container of the images for undo and redo.
	int m_CurrentURPos; //!<This is the index where is located the undo and redo state.
	StringType m_GlobalPath; //!<This is the string with the global path.
	StringType m_IDImages; //!<This is the string with the ID of the images (For the filenames).
};

#endif /* IMAGE3DDEQUEUR_H_ */
