/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageDequeUR.h
 * @brief	This file contains the Image3DDequeUR class. -- Abstract class
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef IMAGEDEQUE_H_
#define IMAGEDEQUE_H_

#include <iostream>
#include <string>
#include <deque>
#include <vtkImageData.h>
#include <vtkSmartPointer.h>
#include "imageInfoUR.h"
#include "imageModificationManager.h"

/*! @class ImageDequeUR imageDequeUR.h "imageDequeUR.cxx"
 *	@brief This class contains the management of the undo/redo - Abstract Class
 */
class ImageDequeUR {
public:
	//typedef definition
	// ----------------------------------------------------------------------------------
	/*!	@typedef vtkSmartPointer<vtkImageData> VTKImageDataPointerType;
	 *	@brief Defines the pointer of vtkImageDate type.
	 */
	typedef vtkSmartPointer<vtkImageData> VTKImageDataPointerType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::string StringType;
	 *	@brief Redefinition of the string type.
	 */
	typedef std::string StringType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef ImageMManager ImageMManagerType;
	 *	@brief Definition of the ImageMManager type.
	 */
	typedef ImageMManager ImageMManagerType;
	// ----------------------------------------------------------------------------------
public:
	// ----------------------------------------------------------------------------------
	/*! @fn ImageDequeUR();
	 * @brief This is the default constructor.
	 */
	ImageDequeUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ~ImageDequeUR();
	 * @brief This is the destructor.
	 */
	virtual ~ImageDequeUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void AddImagesToURContainer(VTKImageDataPointerType imgUndo,
	 VTKImageDataPointerType imgRedo, ImageMManager* imMManager);
	 * @brief This method adds the images for undo and redo in a container
	 * @param imgUndo The undoImage cropped.
	 * @param imgRedo The redoImage cropped.
	 * @param imManager The image manager.
	 */
	virtual void AddImagesToURContainer(VTKImageDataPointerType imgUndo,
			VTKImageDataPointerType imgRedo, ImageMManager* imMManager);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void CleanURContainerFromIndex(const int& index);
	 * @brief This method allows to clean the container from a given index.
	 * @param index The index.
	 */
	virtual void CleanURContainerFromIndex(const int& index);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void ManageMemory();
	 * @brief This method cleans the memory.
	 * @details This method cleans the principal memory when the images are not in use.
	 */
	virtual void ManageMemory();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ImageInfoUR* Undo();
	 * @brief This method is the undo action.
	 * @return
	 */
	virtual ImageInfoUR* Undo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ImageInfoUR* Redo();
	 * @brief This method is the redo action.
	 * @return
	 */
	virtual ImageInfoUR* Redo();
	// ----------------------------------------------------------------------------------
	/*! @fn void SetGlobalPath(const StringType& globalPath);
	 * @brief This method sets the global path where the temporary files will be stored.
	 * @param globalPath The String with the path.
	 */
};

#endif /* IMAGEDEQUE_H_ */
