/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageUndoRedo.h
 * @brief	This file contains the ImageUndoRedo class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef IMAGEUNDOREDO_H_
#define IMAGEUNDOREDO_H_

#include "managerUR.h"

/*! @class ImageUndoRedo imageUndoRedo.h "imageUndoRedo.cxx"
 *	@brief This class manages the undo/redo -- Concrete Class
 *	@details This class derives from ManagerUR
 */
class ImageUndoRedo: public ManagerUR {

public:
	//typedef definition
	// ----------------------------------------------------------------------------------
	/*!	@typedef typedef Image3DDequeUR IDequeType;
	 *	@brief Redefines the Image3DDequeUR type
	 */
	typedef Image3DDequeUR IDequeType;
	// ----------------------------------------------------------------------------------
public:
	// ----------------------------------------------------------------------------------
	/*! @fn ImageUndoRedo();
	 * @brief This is the default constructor.
	 */
	ImageUndoRedo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ~ImageUndoRedo();
	 * @brief This is the destructor.
	 */
	virtual ~ImageUndoRedo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void Undo();
	 * @brief This method manages the undo action.
	 */
	virtual void Undo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void Redo();
	 * @brief This method manages the redo action.
	 */
	virtual void Redo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void SetImage(VTKImageDataPointerType image);
	 * @brief This method sets the modification image (The image which will be modified an manipulated)
	 */
	virtual void SetImage(VTKImageDataPointerType image);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void SetURImages(ImageMManagerType* imMManager);
	 * @brief This methods adds a new image Undo/Redo.
	 */
	virtual void SetURImages(ImageMManagerType* imMManager);
	// ----------------------------------------------------------------------------------
	/*! @fn void UpdateUndoImage();
	 * @brief This method updates the undo image t(m_CurrentImage - 1).
	 */
	void UpdateUndoImage();
	// ----------------------------------------------------------------------------------
	/*! @fn void SetCurrentImage(VTKImageDataPointerType img);
	 * @brief This method sets the image to be manipulated.
	 */
	void SetCurrentImage(VTKImageDataPointerType img);
	// ----------------------------------------------------------------------------------
	/*! @fn VTKImageDataPointerType GetImageRegion(const RegionSType& region,
	 VTKImageDataPointerType img);
	 * @brief This method extract from an image the region of interest (In the undo/redo returns the volume of the modified or t-1 image).
	 */
	VTKImageDataPointerType GetImageRegion(const RegionSType& region,
			VTKImageDataPointerType img);
protected:
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void DrawUR(ImageInfoUR* imageInfo, const bool& undo);
	 * @brief This method writes in the visualized image the changes of the undo/redo.
	 */
	virtual void DrawUR(ImageInfoUR* imageInfo, const bool& undo);
	// ----------------------------------------------------------------------------------
protected:

	IDequeType* m_ImagesDeque; //!<The manager of the ImagesDeque.
	VTKImageDataPointerType m_UndoImage; //!< This is the image for undo t(m_CurrentImage - 1).
	VTKImageDataPointerType m_CurrentImage; //!< This is the current image (The modification image).

};

#endif /* IMAGEUNDOREDO_H_ */
