/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef IMAGEPLANEWIDGET_H
#define IMAGEPLANEWIDGET_H


#include "vtkRenderWindow.h"
#include "vtkRendererCollection.h"
#include "vtkImagePlaneWidget.h"
#include "vtkImageData.h"
#include "vtkColorTransferFunction.h"
#include "vtkImageViewer2.h"
#include "vtkSmartPointer.h"

class ImagePlaneWidget
{
public:
    ImagePlaneWidget();

    virtual void setImage(vtkImageData* img);

    virtual void SetLookupTable(vtkLookupTable *lookuptable);

    virtual void SetColorTable(vtkColorTransferFunction *lookuptable);

    virtual void showPlanes(bool show);    

    virtual bool showImageActors(bool show);

    void setSliceXImageActor(int value);
    void setSliceYImageActor(int value);
    void setSliceZImageActor(int value);
protected:

    vtkImageData* _img;
    vtkImagePlaneWidget* _xwidget;
    vtkImagePlaneWidget* _ywidget;
    vtkImagePlaneWidget* _zwidget;
    vtkImageActor * _imageactorx;
    vtkImageActor* _imageactory;
    vtkImageActor* _imageactorz;

    int xslice;
    int yslice;
    int zslice;

    void initialize(vtkRenderWindowInteractor* interactor);

    void initializeImageActors();

private:
    void invariant();

    vtkRenderWindowInteractor* m_Interactor;

};

#endif // IMAGEPLANEWIDGET_H
