/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef LISTWX_H
#define LISTWX_H

//#include <wx/bmpbuttn.h>
#include <wx/panel.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/bitmap.h>
#include <wx/listctrl.h>
#include <wx/wx.h>


#include <map>
#include <string>
#include "functor.h"
#include <wx/event.h>

#include "system.h"

namespace creaButtonContainer
{

	namespace view
	{

		class ListWx : public wxListCtrl
		{
			public:

				typedef creaButtonContainer::model::TFunctor TFunctor;
				typedef std::map<std::string, wxPanel*> ItemsMap;

			public:

				ListWx( wxWindow* parent, wxWindowID id,ItemsMap iMap , TFunctor* functor );
				// ----------------------------------------------------------------------------------

				virtual
				~ListWx( );
				// ----------------------------------------------------------------------------------

				long
				GetID( );

				void
				ListEvent( wxListEvent& event );
				// ----------------------------------------------------------------------------------
			private:
				ItemsMap m_itemsMap; //! <The pair with the button information.
				TFunctor* functor;

		};
	}//ecapseman
}//ecapseman

#endif // LISTWX_H
