/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



/**
 *  \file 
 *  \brief Class ThresholdImageViewPanel . 
 */

/**
 * \class ThresholdImageViewPanel
 * \brief 
 */
 
#ifndef __mBarRange2_h__
#define __mBarRange2_h__


#include <wx/wx.h>
#include <wx/textctrl.h>
#include "mBarRange.h"


BEGIN_DECLARE_EVENT_TYPES()
 	DECLARE_EVENT_TYPE(wxEVT_BarRange2_Change,-1) 
END_DECLARE_EVENT_TYPES()



	class mBarRange2
		: public wxPanel
		{
		public:
			mBarRange2(wxWindow * parent,int width, int height);		
			~mBarRange2();
			void 		onTxtCtrl(wxCommandEvent& event);
			void 		SetMinMaxValue(double,double);
			void 		SetScalarType(int);
			double 	GetStartValue();
			double 	GetEndValue();
		private:
			double 				_minValue;
			double 				_maxValue;
			double				_startValue;
			double				_endValue;
			int					_scalarType;   
			mBarRange			*_mBarRange;	
			wxTextCtrl 			*_textctrlStart;
			wxTextCtrl 			*_textctrlEnd;
			void 		onBarRangeChange(wxCommandEvent& event);
			wxString CleanNumberStr(wxString string);	
			void 		RefreshTextCntrl();
			void 		createAndSendEvent(WXTYPE theEventType);
			DECLARE_EVENT_TABLE()
		};
	
	
#endif  //__mBarRange2_h__

