/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContourBaseControler_h
#define manualContourBaseControler_h

#include "vtkRenderWindow.h"

#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h" //extremely important with VC++ don't remove !
#include "vtkCommand.h"
#include "vtkPolyData.h"
#include "vtkCellArray.h"
#include "vtkPolyDataMapper.h"
#include "vtkInteractorObserver.h"
#include "vtkInteractorStyleImage.h"
#include <vtkKochanekSpline.h> 

#include <vtkCellPicker.h> 


#include <vtkCamera.h> 
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkUnstructuredGrid.h>

#include <vtkActor.h>
#include <vtkProperty.h>

#include <vtkCellArray.h>
#include <vtkRenderer.h>
#include <vtkCoordinate.h>
#include <vtkTextProperty.h>
#include <vtkTextActor.h>
#include <vtkProperty2D.h>
#include <vtkPointPicker.h>
//#include "widgets/UtilVtk3DGeometriSelection.h"
#include "UtilVtk3DGeometriSelection.h"
//#include "widgets/InteractorStyleMaracas.h"
#include "InteractorStyleMaracas.h"

#include "wxVTKRenderWindowInteractor.h"


//--

#include <vector>
#include "wxVtkBaseView.h"
#include "marTypes.h"

#include "manualContourModel.h"
#include "manualViewBaseContour.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT manualContourBaseControler: public InteractorStyleMaracas
{
public:
	manualContourBaseControler();
	virtual ~manualContourBaseControler();

	virtual manualContourBaseControler * Clone();
	void CopyAttributesTo( manualContourBaseControler *cloneObject );

	virtual bool  OnChar();
	virtual bool  OnMouseMove();
	virtual bool  OnLeftButtonDown(); 
	virtual bool  OnLeftButtonUp();
	virtual bool  OnLeftDClick();
	virtual bool  OnMiddleButtonDown(); 
	virtual bool  OnMiddleButtonUp();
	virtual bool  OnRightButtonDown();
	virtual bool  OnRightButtonUp();

	void	SetModelView(manualBaseModel *manContModel, manualViewBaseContour *manViewBaseCont);
	manualBaseModel		* GetManualContourModel();
	manualViewBaseContour	* GetManualViewBaseContour();


	virtual void	MouseClickLeft(int x, int y);
	virtual void	MouseClickRight(int x, int y);
	virtual void	MouseDLeft(int x, int y);

	virtual void	MouseMove(int x, int y);
	virtual void	MouseReleaseLeft(int x, int y);

	void	SetState(int state);
	int		GetState();
	bool	IsEditable();
	virtual void	SetEditable(  bool condition  );
	bool	GetPosibleToMove();
	void	SetPosibleToMove(  bool condition  );
	bool	IsMoving();
	void	SetMoving(  bool condition  );
	void	SetCompleteCreation( bool condition );
	bool	GetIfCompleteCreation ( );
	void	SetKeyBoardMoving( bool condition );
	bool	GetKeyBoardMoving(  );
	
	void	CreateNewManualContour();
	int		GetNumberOfPointsManualContour();
	int		GetNumberOfPointsSplineManualContour();
	void	DeleteContour();
	virtual void	DeleteActualMousePoint(int x, int y );
	double*	GetVectorPointsXManualContour();
	double*	GetVectorPointsYManualContour();
	

	void	SetZ(int z);
	virtual int		GetZ();

	// VIRTUAL - Adds a point in an specified position
	// @param x - int
	// @param y - int
	// @param z - int
	virtual void	AddPoint(int x, int y, int z);
	virtual void	InsertPoint(int x, int y, int z);

	virtual void	SetPoint(	int id ,int x ,int y ,int z);
			void	SetPointX(	int id ,int x );
			void	SetPointY(	int id ,int y );
			void	SetPointZ(	int id ,int z );

			void	Magnet(int x, int y);
	virtual void	ResetContour();

	virtual void Configure();


//EED Borrame
//	virtual manualContourBaseControler * Clone( manualViewBaseContour * cloneView = NULL, manualContourModel * cloneModel = NULL );


protected:
	
	// Reference to the contour or element view 
	manualViewBaseContour	*_manViewBaseCont;

	// Reference to the model contour or element model 
	manualBaseModel		*_manContModel;

	int						_z;
	int						_state;
	bool					_editable;	
	bool					_posibleToMove;
	bool					_moving;
	bool					_created;
	bool					_keyBoardMoving;
		
}; 


#endif // manualContourBaseControler_h
