/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContourModelCircle_h
#define manualContourModelCircle_h

#include "manualContourModel.h"

class creaMaracasVisu_EXPORT manualContourModelCircle : public manualContourModel
{
public:
	manualContourModelCircle();
	virtual ~manualContourModelCircle();
	virtual manualContourModelCircle *Clone();
	void CopyAttributesTo( manualContourModelCircle *cloneObject);
	virtual void GetSpline_i_Point(int i, double *x, double *y, double *z);
private:
	double		_deltaAngle;
	double		_radio;
	double		_centerX;
	double		_centerY;
	double		_centerZ;

	virtual int		GetTypeModel();  
	virtual void	UpdateSpline();
};

#endif // manualContourModelCircle_h
