/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualViewPoint_h
#define manualViewPoint_h

#include "vtkRenderWindow.h"

#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h" //extremely important with VC++ don't remove !
#include "vtkCommand.h"
#include "vtkPolyData.h"
#include "vtkCellArray.h"
#include "vtkPolyDataMapper.h"
#include "vtkInteractorObserver.h"
#include "vtkInteractorStyleImage.h"
#include <vtkKochanekSpline.h> 

#include <vtkCellPicker.h> 
#include <vtkCamera.h> 
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkUnstructuredGrid.h>

#include "wxVTKRenderWindowInteractor.h"

#include <vector>
#include "wxVtkBaseView.h"
#include "marTypes.h"

//--------------------------------------------------------

class manualViewPoint{
public:

	manualViewPoint(wxVtkBaseView *wxvtkbaseview);
	virtual ~manualViewPoint();

	virtual manualViewPoint * Clone();
	void CopyAttributesTo( manualViewPoint *cloneObject );
	void		SetSelected(bool selected);
	void		SetPosibleSelected(bool posibleSelected);
	bool		GetSelected();
	bool		GetPosibleSelected();
	void		DeleteVtkObjects();
	vtkActor*	CreateVtkPointActor();

	//
	// Sets the x,y,z position to the actual point. Establishes a range of the points respect 
	// to the final coordinate.
	// @param x - double
	// @param y - double
	// @param z - double
	// @param range - double
	//
	void		SetPositionXY(double x, double y, double range, double posZ);

	//
	// Get ViewPoint VtkActor
	// @return vtkActor*
	//
	vtkActor*   GetVtkActor();
	
	//
	// Updates the color and width of the actual point if the VTK Actor has been created
	//
	void		UpdateColorActor();	

	//
	// Updates the point normal color of the actual point.
	//
	void UpdateColorActor(double nR, double nG, double nB);

	void		GetSpacing(double spc[3]);
	void		SetSpacing(double spc[3]);
	void		SetWidthLine( double width);


private:

	//
	// Is point selected
	//
	bool				_selected;	
	bool				_posibleSelected;
	
	vtkPoints			*_pts;
	
	//
	// Point VTK PolyData object 
	//
	vtkPolyData			*_pd;

	//
	// Point VTK Actor
	//
	vtkActor			*_pointVtkActor;

	//
	// Point VTK PolyData mapper
	//
	vtkPolyDataMapper	*_bboxMapper;

	//
	// Reference to VtkBaseView
	//
	wxVtkBaseView		*_wxvtkbaseview;

	//
	// Line Width (def=1)
	//
	double				_widthline;
protected:

	//
	// Point spacing (def=1)
	//
	double		_spc[3];

	// Point normal color
	double		_colorNormal_r;
	double		_colorNormal_g;
	double		_colorNormal_b;

	// Posible selected point color
	double		_colorPosibleSelected_r;
	double		_colorPosibleSelected_g;
	double		_colorPosibleSelected_b;
};

#endif // manualViewPoint_h
