/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  */

#ifndef __MAR_IMAGE_DATA__h
#define __MAR_IMAGE_DATA__h
#include "marTypes.h"
#include <vector>

#include "vtkImageData.h"

class creaMaracasVisu_EXPORT marImageData
{
public:
	marImageData(vtkImageData *imagedata);
	~marImageData();

	void SetSpcOriginal(double spc[3]);
	void SetVoiOriginal(int voi[6]);
	void AddImageData(vtkImageData *imagedata);

	void removeImageData(int index);

	void GetSpcOriginal(double spc[3]);
	void GetVoiOriginal(int voi[6]);
	vtkImageData *GetImageData();
	vtkImageData *GetImageDataT(int t);
	int GetMaxT();

	int GetXOriginal(int value);
	int GetYOriginal(int value);
	int GetZOriginal(int value);

private:
	double						_spcOriginal[3];
	int							_voiOriginal[6];
	std::vector<vtkImageData *> _imagedataLST;
//	vtkImageData		*_imagedata;
protected:

};



#endif   //  __MAR_IMAGE_DATA__h


