/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKCLIPPING3DDATAVIEWER_H_
#define VTKCLIPPING3DDATAVIEWER_H_

#include "wxMPRBaseData.h"

#include "vtkClipPolyData.h"
#include "vtkStripper.h"
#include "vtkLODActor.h"
#include "vtkMarchingCubes.h"
#include "vtkVolumeRayCastMapper.h"
#include "boxSurfaceObserver.h"
#include "vtkVolumeRayCastCompositeFunction.h"
#include <vtkPiecewiseFunction.h>
#include "vtkVolumeProperty.h"
#include "vtkPolyDataMapper.h"
#include "vtkColorTransferFunction.h"
#include "vtkVolume.h"
#include "vtkActor.h"
#include "vtkOutlineFilter.h"
#include "vtkRenderWindowInteractor.h"

#include "vtkVolumeRayCastMIPFunction.h"

#include "volumerendererdata.h"

class vtkClipping3DDataViewer {
public:
	//----------------------
	//Constructo-Destructor
	//----------------------
	vtkClipping3DDataViewer();
	virtual ~vtkClipping3DDataViewer();

//	vtkImageActor*			GetImageActor(int id);
	vtkActor*				GetOutlineActor();
	vtkClipPolyData*		GetTissueClipper(int id);
	vtkPolyDataMapper*	GetTissueMapper(int id);
	vtkPlanes*				GetTissuePlanes(int id);
	vtkStripper*			GetTissueStripper(int id);
//	vtkGlyph3D*				GetGlyph(int id);
	vtkLODActor*			GetMaceActor(int id);

	vtkMarchingCubes		*GetMCubes(int idTissue);

	virtual void			Refresh();
	void						RefreshSurface();

	virtual void			Configure();
	void						Configure_Tissue();
	void						Configure_Volume();
	
	void						SetIsovalue(int idTissue, int isoValue);
	double					GetIsovalue(int idTissue);

	vtkVolume				*GetVolumeActor();
	vtkVolumeRayCastMapper  *GetVolumeMapper();
	vtkPlanes				*GetVolumePlanes();

	void						SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata);
	vtkMPRBaseData*		GetVtkMPRBaseData();

	vtkActor					*GetTissueActor(int id);
	void						SetVisibleTissue(int idTissue, bool visible);
	bool						GetVisibleTissue(int idTissue);
	bool						GetVisibleVolume();
	void						SetVisibleVolume(bool visibleVolume);

   bool						GetVisibleVolumeBox();
	void						SetVisibleVolumeBox(bool visibleBox);

	void						SetRepresentationType(int idTissue, bool representationType);
	bool						GetRepresentationType(int idTissue);

	boxSurfaceObserver	*GetObserverS(int idObserverS);
	boxSurfaceObserver	*GetObserverV();

	//void					ReadVolumeFunctions(char *namefile);
	void						ReadVolumeFunctions();
	void						ReadMeshVTK(char *namefile);


    void						Configure_VolumeBox();
    void						SetInteractor(vtkRenderWindowInteractor* interactor);
    void						SetRenderer(vtkRenderer* renderer);

	//-------------------
	//Getters Vectors
	//-------------------

	std::vector<double>*					GetGreyValuesTransferenceFVector();
	std::vector<double>*					GetIntensityValuesTransferenceFVector();
	std::vector<double>*					GetRedColorsOfColorTransferenceFVector();
	std::vector<double>*					GetGreenColorsOfColorTransferenceFVector();
	std::vector<double>*					GetBlueColorsOfColorTransferenceFVector();
	std::vector<double>*					GetGreyValueColorsOfColorTransferenceFVector();

	void setColorTransferFunction(vtkColorTransferFunction* colortable);

	//--------------------------------------
	//Getters transference function
	//and color of the transference function
	//---------------------------------------
	vtkPiecewiseFunction			*GetTransferencefunction();
	vtkColorTransferFunction	*GetColorTransferenceFunction();

	void                      SetRayCasting(bool active);
	void                      SetMIPActive(bool active);
   void                      SetInterpolation(bool active);
   void                      SetShade(bool active);
   void                      updateVolume();
   void                      BoxActorChanged(bool changed);
   void                      UpdateVolumeBox(vector<double> gf, vector<double> vf, vtkColorTransferFunction* ctfun);



private:

	vtkMarchingCubes				*_mCubes[ VTKMPRDATA_MAXTISSUE ];
	vtkStripper						*_tissueStripper[ VTKMPRDATA_MAXTISSUE ];
	vtkPolyDataMapper				*_tissueMapper[ VTKMPRDATA_MAXTISSUE ];
	vtkPlanes						*_tissuePlanes[ VTKMPRDATA_MAXTISSUE ];
	vtkClipPolyData				*_tissueClipper[ VTKMPRDATA_MAXTISSUE ];

	// outline
	vtkOutlineFilter				*_outlineData;
	vtkPolyDataMapper				*_mapOutline;
	vtkActor							*_outline;

	/// Volume
	vtkPiecewiseFunction			*_tfun;
	vtkColorTransferFunction	*_ctfun;
//	vtkVolumeRayCastCompositeFunction	*_compositeFunction;
	vtkPlanes						*_volumePlanes;
	vtkVolumeRayCastMapper		*_volumeMapper;
	vtkVolumeProperty				*_volumeProperty;
	vtkVolume						*_newvol;
	vtkMPRBaseData					*_vtkmprbasedata;
	bool								_visibleVolume;
   bool								_visibleVolumeBox;
	bool								_representationType[VTKMPRDATA_MAXTISSUE];
	bool								_visibleTissue[VTKMPRDATA_MAXTISSUE];
	vtkActor							*_tissue[VTKMPRDATA_MAXTISSUE];
	boxSurfaceObserver			*_observerV;
	boxSurfaceObserver			*_observerS[VTKMPRDATA_MAXTISSUE];

	std::vector<double>			greyValuesTransferenceFVector;
	std::vector<double>			intensityValuesTransferenceFVector;
	std::vector<double>			redColorsOfColorTransferenceFVector;
	std::vector<double>			greenColorsOfColorTransferenceFVector;
	std::vector<double>			blueColorsOfColorTransferenceFVector;
	std::vector<double>			greyValueColorsOfColorTransferenceFVector;

	vtkVolumeRayCastCompositeFunction   *_compositeFunction;
	vtkVolumeRayCastMIPFunction         *_compositeFunctionMIP ;

	bool _isRayCasting;
   bool _isMIP;
	bool _interpolation;
	bool _shade;

	VolumeRendererData* _volumerendererdata;
};

#endif /*VTKCLIPPING3DDATAVIEWER_H_*/
