/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkClosePolyData.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.3 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkClosePolyData - close a polygonal dataset
// .SECTION Description
// 
// vtkClosePolyData is a filter that blabla

// .SECTION Thanks
// Thanks to Goodwin Lawlor for http://public.kitware.com/pipermail/vtkusers/2003-March/016420.html
// and Mathieu Malaterre for this class.

// .SECTION See Also
// vtkAppendFilter

#ifndef __vtkClosePolyData_h
#define __vtkClosePolyData_h

#include "vtkPolyDataToPolyDataFilter.h"

class vtkClosePolyData : public vtkPolyDataToPolyDataFilter
{
public:
  static vtkClosePolyData *New();

  vtkTypeRevisionMacro(vtkClosePolyData,vtkPolyDataToPolyDataFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

protected:
  vtkClosePolyData();
  ~vtkClosePolyData();

  // Usual data generation method
  void Execute();

private:
  vtkClosePolyData(const vtkClosePolyData&);  // Not implemented.
  void operator=(const vtkClosePolyData&);  // Not implemented.
};

#endif


