/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wxMaracasRenderTabbedPanel_H_
#define wxMaracasRenderTabbedPanel_H_

#include <wx/wx.h>
#include <wx/notebook.h> 

#include "wxMaracasRenderImageManagementPanel.h"
#include "volumerenderermanager.h"
#include "wxMaracasSurfaceRenderingManager.h"
#include "wxVtkBaseView.h"
#include "wxMPRWidget.h"


class wxMaracasRenderTabbedPanel : public wxPanel
{
	
public:
	wxMaracasRenderTabbedPanel(wxWindow* parent, int id, wxVtk3DBaseView* _baseView);
	~wxMaracasRenderTabbedPanel();

	void createControls(vtkImageData* inImg, std::string pathfile, std::string filename);
	void setRenderer(vtkRenderer* rend);
	void addVolume(vtkImageData* img, std::string dataname);
	void addSurface1(vtkImageData* img, std::string dataname);
	void addSurface2(vtkImageData* img, std::string dataname);
	void addSurface3(vtkImageData* img, std::string dataname);

	void deleteVolume(int volid);
	void addRemoveActorV(int id, bool addremove);
	void addRemoveActorSA(int id, bool addremove);
	void addRemoveActorSB(int id, bool addremove);
	void addRemoveActorSC(int id, bool addremove);
	void addRemoveActorMPR(bool addremove);
	void addMPROptions();

	// ----- Volume rendering functions ----- //
	void SetValuesColorPointsFunction(int volid, std::vector<double> greylevelcolors,std::vector<double> red,std::vector<double> green,std::vector<double> blue);
	void SetValuesPointsFunction(int volid, std::vector<double> greylevel, std::vector<double> values);
	vtkPiecewiseFunction* GetTransferFunction(int volumeid);
	vtkColorTransferFunction* GetColorFunction(int volumeid);

	// ----- Surface rendering functions ----- //
	void changeOpacityA(int _propid, int value);
	void changeIsoValueA(int propid, double value);
	void changeColorA(int propid, double red, double green, double blue);
	void changeOpacityB(int _propid, int value);
	void changeIsoValueB(int propid, double value);
	void changeColorB(int propid, double red, double green, double blue);
	void changeOpacityC(int _propid, int value);
	void changeIsoValueC(int propid, double value);
	void changeColorC(int propid, double red, double green, double blue);
	
	void onCheckBoxVChange(wxCommandEvent& event);
	void onCheckBoxSAChange(wxCommandEvent& event);
	void onCheckBoxSBChange(wxCommandEvent& event);
	void onCheckBoxSCChange(wxCommandEvent& event);
	void onMPROptions(wxCommandEvent& event);

	void onOpenParameters(wxCommandEvent& event);
	void onColorChange(wxCommandEvent& event);
	void onOpenCutter(wxCommandEvent& event);
	void OnRefreshView(wxCommandEvent& event);

	vtkImageData* getVolImage();
	vtkImageData* getSurfAImage();
	vtkImageData* getSurfBImage();
	vtkImageData* getSurfCImage();

	int getPropIdV();
	
private:
	wxCheckBox* checkboxVol;
	wxCheckBox* checkboxSA;
	wxCheckBox* checkboxSB;
	wxCheckBox* checkboxSC;
	wxCheckBox* checkboxViewer;
	wxPanel*	controlPanelMPR3D;
	wxNotebook* wxtabs;
	wxString	volname;
	
	wxVtk3DBaseView*	baseView;
	wxVtkMPR3DView*		mwxvtkmpr3Dview;
	vtkMPR3DDataViewer* vtkmpr3Ddataviewer;

	bool first;
	int _id;

	wxMaracasRenderImageManagementPanel*	dialog;
        VolumeRendererManager* volmanager;
	wxMaracasSurfaceRenderingManager*		surrendmanager1;
	wxMaracasSurfaceRenderingManager*		surrendmanager2;
	wxMaracasSurfaceRenderingManager*		surrendmanager3;

	DECLARE_EVENT_TABLE( );
};

#endif /*wxMaracasMultipleVolumeRendererPanel_H_*/

