/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxMaracasSuperpositionPanelH__
#define __wxMaracasSuperpositionPanelH__

// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/scrolwin.h>

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include "wxMaracas_N_ViewersWidget.h"
#include "vtkImageData.h"
#include "wxVtkBaseView.h"

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class creaMaracasVisu_EXPORT wxMaracasSuperpositionPanel : public wxPanel
{

public:

	wxMaracasSuperpositionPanel( std::vector<vtkImageData*> imgs, int type, wxWindow *parent, const wxPoint& pos=wxDefaultPosition, 
	const wxSize& size = wxDefaultSize,long style= wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER, int vertStart=1, int vertEnd=1, 
	int horzStart=1, int horzEnd=1 );


	~wxMaracasSuperpositionPanel();	

//------------------------------------------------------------------------------------------------------------
// Creational and initialization methods
//------------------------------------------------------------------------------------------------------------
	
	void createSuperpositionPanel();

//------------------------------------------------------------------------------------------------------------
//  Other functional methods
//------------------------------------------------------------------------------------------------------------

	void getSpacing( double * spacing );

	wxVtkBaseView* GetWxVtkBaseView();
	wxVtkMPR2DView * GetwxVtkMPR2DView();
	vtkImageData * GetshowingVID();
	int GetImageDataSizeZ();
	void RefreshInterface();
	void ChangeImage(vtkImageData* img);
	
	void	SetVisibleAxis(bool ok);
	int		GetX();
	int		GetY();
	int		GetZ();
	void	Refresh();	
	

private:

	std::vector<vtkImageData*> _images;
	
	
	int _type;
	
	/*
	* Represents the panel for viewing
	*/
	wxMaracas_N_ViewersWidget * theViewPanel;
	
	/*
	* Represents the outer sizer of the IRMViewPanel
	*/
	wxFlexGridSizer* outSizer;

	double last_spacing[3];
	
};

#endif /*__wxMaracasSuperpositionPanelH__*/
