/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_N_ViewersWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.14 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MARACAS__N_VIEWERSWIDGET__H__
#define __WX__MARACAS__N_VIEWERSWIDGET__H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include "vtkImageData.h"
#include "wxMaracas_ViewerWidget.h"
#include <iostream>
#include <vector>

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class creaMaracasVisu_EXPORT wxMaracas_N_ViewersWidget : public wxPanel
  {
  public:


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	/**
	*	@pre A wxWindow* object must be provided as a parent for the viewer
	*	@post The layout of the viewer is initialize, if there is no image or type set,
			only the panel of the viwer is created with no vtk objects
	*	@param wxWindow* parent of the window
	*	@param vtkImageData* imagedata of the viewer
	*	@param std::vector<int>* vector of the type for the viewer
	*	@deprecated This method will be eliminated in future versions,
	*	@deprecated the viewers will start with a default image if it is not specified,
	*	@deprecated this is in order to create the layout of the viewer,
	*	@deprecated the vtkInteractors* and the object vtkRenderer* use second constructor
	*/
	wxMaracas_N_ViewersWidget(wxWindow *parent, vtkImageData* imagedata = NULL, std::vector<int> *nTypeView = NULL);
	/**
	*	@pre A wxWindow* object must be provided as a parent for the viewer and the type of layout for the viewer
	*	@post The layout of the viewer is initialized, if no image is provided at first, a default image is
	*		used
	*	@param wxWindow* parent of the window
	*	@param std::vector<int>* vector of the type for the viewer
	*	@param vtkImageData* imagedata of the viewer
	*/
	wxMaracas_N_ViewersWidget(wxWindow *parent, std::vector<int> *nTypeView, vtkImageData* imagedata = NULL);
	/**
	*	@pre none
	*	@post the viewer window is deleted, all of the interactors and the renderer are deleted
	*/
	~wxMaracas_N_ViewersWidget();


	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

    void Update();
    vtkRenderer *GetRenderer();
	void RefreshView();

	virtual void OnRefreshView(wxCommandEvent & event);
	void OnDClickLeft(wxCommandEvent & event);
	wxMaracas_ViewerWidget *GetWindow(int iWin);
	wxVtkBaseView *GetwxVtkBaseView(int iWin);
 	virtual void Refresh(bool eraseBackground = true,const wxRect* rect = NULL );
	void SetImage( vtkImageData *image	);
	void ConfigureVTK();
	void SetType(std::vector<int>* type);
	void UpdateLayout(vtkImageData* imagedata);
//	double GetZ(int iWin);
	double GetX();
	double GetY();
	double GetZ();

	void setColorTransferFunction(vtkColorTransferFunction* colortable);
    void SetColorWindowLevel(double colorWindow, double colorLevel);

	//------------------------------------------------------------------------------------------------------------
	// Attributes
	//------------------------------------------------------------------------------------------------------------

  private:

	wxPanel *wxw1;
	wxPanel *wxw2;
	wxPanel *wxw3;
	wxPanel *wxw4;
	wxMaracas_ViewerWidget	*wxwindow1;
	wxMaracas_ViewerWidget	*wxwindow2;
	wxMaracas_ViewerWidget	*wxwindow3;
	wxMaracas_ViewerWidget	*wxwindow4;

	wxWindow *_currentwxw;


	std::vector<int> *nTypeView;

	vtkMPRBaseData* mvtkmprbasedata;

	void invariant();
  DECLARE_EVENT_TABLE( );
  };


#endif // __WX__MARACAS__N_VIEWERWIDGET__H__
