/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_ViewerWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.13 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MARACAS__VIEWERWIDGET__H__
#define __WX__MARACAS__VIEWERWIDGET__H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include "vtkImageData.h"
#include "vtkRenderer.h"

#include "wxVtkBaseView.h"
#include "wxMPRWidget.h"

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

 class wxMaracas_ViewerWidget : public wxPanel
  {
  public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

    wxMaracas_ViewerWidget(wxWindow *parent, vtkImageData* imagedata, int type, vtkMPRBaseData *vtkmprbasedata=NULL);
    ~wxMaracas_ViewerWidget();

	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

//    vtkRenderer *GetRenderer();
	void ConfigureVTK();
	void RefreshView();
	virtual void Refresh(bool eraseBackground = true,const wxRect* rect = NULL );

	wxVtkBaseView *GetwxVtkBaseView();
	void SetImage( vtkImageData *image	);
	double GetX();
	double GetY();
	double GetZ();

	//------------------------------------------------------------------------------------------------------------
	// Attributes
	//------------------------------------------------------------------------------------------------------------

	void setColorTransferFunction(vtkColorTransferFunction* colortable);

  void SetColorWindowLevel(double colorWindow, double colorLevel);
	  
  private:
		int								mType;

		bool                            minternalVtkmprbasedata;
		vtkMPRBaseData					*mvtkmprbasedata;


		wxVtk2DBaseView					*mvtk2Dbaseview;
		wxVtkMPR2DView					*mvtkmpr2Dview_X;
		wxVtkMPR2DView					*mvtkmpr2Dview_Y;
		wxVtkMPR2DView					*mvtkmpr2Dview_Z;
		wxWidgetMesure2D_Plane_in_MPR	*mwidgetMesure;
		vtkPlane2DView					*mvtkplane2Dview;
		wxSphereView					*mwxsphereview;

		wxVtkClipping3DView				*mwxvtkclipping3Dview;
		wxVtk3DBaseView					*mwxvtk3Dbaseview_Clipping3D;
		wxVtkMPR3DView					*mwxvtkmpr3Dview;


		vtkMPR3DDataViewer				*vtkmpr3Ddataviewer;

  };

#endif // __WX__MARACAS__VIEWERWIDGET__H__
