/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef WX_STL_WIDGET_03
#define WX_STL_WIDGET_03

#include <vector>

#include <vtkImageData.h>
#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>
#include <vtkAppendFilter.h>
#include <vtkImageThreshold.h>
#include <vtkExtractVOI.h>
#include <vtkOutlineFilter.h>
#include <vtkImageSeedConnectivity.h>
#include <vtkImageCast.h>

#include "wxVTKRenderWindowInteractor.h"
//#include "wxSurfaceWidget.h"
#include "wxVtkBaseView.h"


#include "../wxMaracasMPR.h"
#include "pPlotter/mBarRange.h"//SIL//

//#include <marInterface.h>
//#include <include/axisExtractor02.h>


#include "vtkSTLExtractor.h"    
#include "include/vtkJoiner.h"

#include "marTypes.h"




//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class creaMaracasVisu_EXPORT wxSTLWidget_03: public wxPanel{
public:
	wxSTLWidget_03(wxWindow *parentmar);//,marInterface *mar);
	~wxSTLWidget_03();
	void ConfigureVTK();
	void Refresh();

	void OnOpacity_Vol(wxScrollEvent& event);		// Result Volume 
	void OnMinSpin ( wxScrollEvent & event );
	void OnMaxSpin ( wxScrollEvent & event ); 

	//SIL new// 
	void OnRangeSpin( wxScrollEvent & event );

	//Handled events form the bar
	void OnStartChanged_range(wxCommandEvent& event);
	void OnEndChanged_range(wxCommandEvent& event);
	void OnBarMoved_range(wxCommandEvent& event);


	void OnBtnExtraction(wxCommandEvent& event);
	void OnBtnSaveBinaryFile(wxCommandEvent& event);

	//
	void Reset_vtk_STLFile();
	void OnBtnSTLFileLoad(wxCommandEvent& event);
	void OnBtnSTLFileErase(wxCommandEvent& event);
	void OnOpacitySTLFile(wxScrollEvent& event);		


	// --------------------------------------
	// STL FUNCTIONS DHC
	// --------------------------------------
	void generateSTLSurfaces();
	void OnBtnCreateFileSTL(wxCommandEvent& event); 
	void OnChangeSTLGaussLevel(wxScrollEvent& event);
	void OnChangeSTLMarchingCubesLevel(wxScrollEvent& event);
	void OnOpacitySTLExternal(wxScrollEvent& event);
	void OnOpacitySTLInternal(wxScrollEvent& event);

	
	//---------------------------------------
	// JOIN REGIONS FUNCTIONS
	//---------------------------------------
	void OnJoinRegions(wxCommandEvent& event);

	//JCP 01-03-08
	void setImage(vtkImageData* img);

private:

	//Processing
	vtkImageData				*_imagedata;
	double 						_range[2];
	vtkImageCast				*cast2;
	vtkImageCast				*cast3;
	vtkImageCast				*cast4; // binary segmentation result
	vtkImageThreshold			*_thresh;
	vtkImageThreshold			*_thresh2;
	vtkImageCast * _cast;
	vtkImageSeedConnectivity	*_connect;
	vtkImageSeedConnectivity	*_connect2;



	vtkPolyDataMapper	*_2_mapfinal;
	vtkActor			*_2_stripfinal;
	vtkPolyDataMapper	*_2_isoMapperMC6;
	vtkActor			*_2_isoActorMC6;
	vtkMarchingCubes	*_2_isoMC6;
	double				_sensibility_JF;
	int					_maxSize;
	int					_minSize;

	// Load STL file
	vtkPolyDataMapper *_loadSTLMapper;
	vtkActor		  *_loadActorSTL;


	wxSlider			*_opacity_Vol;
	wxSlider			*_sl_minSize;
	wxSlider			*_sl_maxSize;
	wxSlider			*_sl_minSizeSpin;
	wxSlider			*_sl_maxSizeSpin;
	wxSlider			*_sl_RangeSizeSpin;

	
	/*
	* Represents the bar of min and max for merging the functionality of two sliders for controlling the segmentation parameters
	*/
	mBarRange			* sl_barrange_segmentation;
	int					lastResizeRef_Value;
	int					minRangeValue;
	int					maxRangeValue;
	
	wxVtk3DBaseView		*_imageviewer3D;
	wxPanel				*CreateControlPanel(wxWindow *parent);
	wxPanel				*CreateViewPanel(wxWindow *parent);

	//Maracas
	//marInterface		*_mar;
	wxMaracasMPR		*_wxMaracasMPR;

	void ResetTree2_JF();
	void ExtractSurface(int x, int y, int z);

	wxWindow* CreateSelectAPointPanel(wxWindow *parent);
	wxWindow* CreateSegmentationPanel(wxWindow *parent);
	wxWindow* CreateSmoothingPanel(wxWindow *parent);
	wxWindow* CreateReadSTLFilePanel(wxWindow *parent);

	//---------------------
	// Processing
	//---------------------
	void ConfigureProcessing(vtkImageData *img, int x, int y, int z);


	//---------------------
	// STL SURFACES DHC
	//---------------------
	void		ConfigureSTL();
	double		_stlDeltaGaussLevel;
	double		_stlMarchingCubesLevel;

	
	vtkPolyData *stlInterna;
	vtkPolyData *stlExterna;
	
	wxSlider	*stlSliderDeltaGauss;
	wxSlider	*stlSliderMarchingCubes;
	
	vtkPolyDataMapper *dsm1;
    vtkActor	*actorInternal;
	wxSlider	*stlSliderOpacityInternal;
    
	vtkPolyDataMapper *dsm2; 
    vtkActor	*actorExternal;
	wxSlider	*stlSliderOpacityExternal;

	vtkSTLExtractor *stlExtractor;   

	wxSlider	*_sl_opacity_STL_file;



	//--------------------------
	// JOIN REGIONS
	//--------------------------

	vtkImageData		*arteryImageData;
	vtkJoiner			*joiner;
	vtkMarchingCubes	*joinMarchingCubes;
    vtkPolyDataMapper	*joinMapper; 
	vtkActor			*joinActor; 

};

#endif // WX_STL_WIDGET_03




