/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTKMPR3DVIEW_H_
#define WXVTKMPR3DVIEW_H_

#include "vtkMPR3DDataViewer.h"
#include "wxVtkMPR3DViewCntrlPanel.h"
#include "wxVtk3DBaseView.h"

#include "vtkProbeFilter.h"
#include "vtkPlaneWidget.h"
#include "vtkPointWidget.h"
#include "vtkImagePlaneWidget.h"


//class vtkmyPWCallback_3DPointWidget;
class wxVtkMPR3DViewCntrlPanel;

class creaMaracasVisu_EXPORT wxVtkMPR3DView
{
public:
	wxVtkMPR3DView( wxVtk3DBaseView *wxvtk3Dbaseview );
	virtual ~wxVtkMPR3DView();	
	void				VisibleImageActor(int idPosition, bool visible);
	void				VisiblePointWidget( bool visible );
	void				VisiblePlaneWidget( bool visible );

	void				SetVisibleTissue(int idTissue, bool visible);
	bool				GetVisibleTissue(int idTissue);
	virtual void		Refresh();
	virtual void		RefreshView();
	virtual void		Configure();
	void				SetVtkMPR3DDataViewer( vtkMPR3DDataViewer *vtkmpr3Ddataviewer );
	wxPanel*			CreateControlPanel(wxWindow *parent, bool align);

	vtkMPR3DDataViewer* GetVtkMPR3DDataViewer();
	wxVtk3DBaseView*	GetWxvtk3Dbaseview() throw (char*);

	void				InitOrientationPointWidget(); 
	void				showOutlineActor(bool value);

	// EED 25 Janvier 2007 testLoic
	void				TestLoic1();
	void				TestLoic2();

	void RemoveActor(vtkActor* actor);

//EED 27/05/2013
//	void ResetCamera(int *ext=NULL,double* spc=NULL);

	void setColorTransferFunction(vtkColorTransferFunction* colortable);

	
	//Free planes
	//-------------------------------------------------------------------
	void ConfigureFreePlanes();
	vtkImagePlaneWidget* GetPlaneWidget(unsigned char activationkey, double r, double g, double b, vtkCellPicker* picker);
	void FreePlaneVisible(int plane, bool ok);
	void FreePlaneInteraction(bool ok);
	void SetFreePlanesOrtho();
	
	void SetColorWindow(double colorWindow);
	void SetColorLevel(double colorLevel);

	
private:
	wxVtk3DBaseView					*_wxvtk3Dbaseview;
	vtkMPR3DDataViewer				*_vtkmpr3Ddataviewer;
	wxVtkMPR3DViewCntrlPanel		*_wxvtkmpr3DviewCntrlPanel;

	// Plane Widget (3D)
	vtkPolyData						*_vtkplane;
	vtkActor						*_contourPlaneActor;
	vtkPlaneWidget					*_planeWidget;

	// Point Widget (3D)
	vtkPointWidget					*_pointWidget;
	//vtkmyPWCallback_3DPointWidget	*_myCallback;
	vtkProbeFilter					*_probe;
	vtkPolyDataMapper				*_contourMapper;

	//Free planes
	vtkImagePlaneWidget *_planeWidgetX;
	vtkImagePlaneWidget *_planeWidgetY;
	vtkImagePlaneWidget *_planeWidgetZ;
	

protected:
};

#endif /*WXVTKMPR3DVIEW_H_*/
