/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXWIDGETMESURE2D_PLANE_H_
#define WXWIDGETMESURE2D_PLANE_H_

#include "wxWidgetMesure2D.h"
#include "wxVtk2DBaseView.h"

class wxWidgetMesure2D_Plane : public wxWidgetMesure2D
{
public:
	 wxWidgetMesure2D_Plane(wxWindow *parent);
	 ~wxWidgetMesure2D_Plane();
	void			OnActiveLine(wxCommandEvent& event);
	void			OnActiveCirlcle(wxCommandEvent& event);
	virtual void	ConfigureA(wxVtk2DBaseView *wxvtk2Dbaseview);
	void			ConfigureCircleLine();
	void			CircleLine();

protected:
	virtual wxWindow		*CreateWin1a(wxWindow *parent);
private:
	wxCheckBox				*_cb_line; 
	wxCheckBox				*_cb_circle; 

	// Circle 1
	vtkPoints					*_ptsCircle1;
	vtkActor					*_circle1Actor;
	vtkPolyDataMapper			*_circle1Mapper;
    vtkPolyData					*_pdCircle1;
	// Circle 2
	vtkPoints					*_ptsCircle2;
	vtkActor					*_circle2Actor;
	vtkPolyDataMapper			*_circle2Mapper;
    vtkPolyData					*_pdCircle2;
	// line reference 1
	vtkPoints					*_ptsLineRef1;
	vtkActor					*_lineRef1Actor;
	vtkPolyDataMapper			*_lineRef1Mapper;
    vtkPolyData					*_pdLineRef1;
	// line reference 2
	vtkPoints					*_ptsLineRef2;
	vtkActor					*_lineRef2Actor;
	vtkPolyDataMapper			*_lineRef2Mapper;
    vtkPolyData					*_pdLineRef2;

	void SetVisibleCircle( bool ok );

};

#endif /*WXWIDGETMESURE2D_PLANE_H_*/
